<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

use SVG\Nodes\Shapes\SVGPath;
use SVG\Nodes\Structures\SVGSymbol;

class FoodShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'food';

    protected function symbolPath()
    {
        return 'm 347.5247,186.63447 c 92.691,0 167.86068,75.17151 167.86068,167.86066 0,92.691 -75.17152,167.86066 -167.86068,167.86066 -92.691,0 -167.86066,-75.1715 -167.86066,-167.86066 0,-92.691 75.17151,-167.86066 167.86066,-167.86066 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 347.00391,133.85742 c -30.13244,0.259 -60.20911,6.85692 -87.61262,19.41455 -21.64468,9.87469 -41.62631,23.36554 -58.88921,39.73526 -24.24377,22.92634 -43.1389,51.50082 -54.56748,82.86031 -10.73096,29.32649 -14.89903,61.00122 -12.29725,92.11256 2.26134,27.40529 9.76207,54.38808 22.16218,78.94208 15.23721,30.32654 37.72106,56.97212 65.04534,77.10166 26.04441,19.24978 56.47259,32.56688 88.32846,38.45507 38.78794,7.23006 79.55941,3.73587 116.45578,-10.30279 28.87083,-10.92777 55.30201,-28.18839 76.9972,-50.13995 23.55465,-23.75439 41.51436,-53.03615 51.88842,-84.84671 8.53623,-26.00154 11.94356,-53.63958 10.21047,-80.94212 -1.59505,-25.41777 -7.67221,-50.56517 -18.04899,-73.83176 -14.3984,-32.48562 -36.97045,-61.29245 -65.03111,-83.0885 -26.69099,-20.77993 -58.30956,-35.23889 -91.55305,-41.57081 -14.185,-2.73494 -28.64349,-4.02765 -43.08814,-3.89885 z m -1.2168,39.69336 c 4.5312,0.004 8.95424,0.14122 13.47461,0.45117 7.98738,0.57016 16.12306,1.67648 24.03745,3.30246 5.79657,1.1865 11.60459,2.68131 17.30793,4.45414 11.47662,3.56073 22.71694,8.30562 33.27893,14.14088 12.49664,6.86481 24.30639,15.3725 34.85853,25.07575 3.84045,3.5196 7.60545,7.31485 11.07771,11.08537 9.39128,10.26165 17.63952,21.57597 24.45117,33.70703 2.13837,3.80531 4.2174,7.84095 6.06161,11.80446 3.35839,7.17251 6.2472,14.68009 8.61937,22.27863 1.13537,3.60776 2.18889,7.42401 3.08363,11.10361 1.82921,7.52309 3.17021,15.17555 4.02336,22.82692 0.88668,8.01547 1.23033,15.96491 1.06528,24.05409 -0.0532,2.44447 -0.15263,4.86775 -0.30711,7.24628 -0.7377,12.08283 -2.72625,24.23738 -5.92952,35.99242 -3.14245,11.5138 -7.49533,22.87504 -12.89516,33.59359 -8.20179,16.30308 -18.98204,31.48728 -31.77357,44.59392 -15.75651,16.21112 -34.56271,29.45734 -55.16664,38.7678 -7.11617,3.21132 -14.63227,6.02958 -22.11197,8.25477 -10.14965,3.04354 -20.5674,5.18692 -31.09311,6.40538 -2.2475,0.25005 -4.6816,0.4963 -7.00923,0.66744 -5.91908,0.45654 -12.05235,0.62687 -18.06464,0.48387 -2.9382,-0.0573 -6.0099,-0.21459 -9.01207,-0.42474 -1.96681,-0.15584 -4.1309,-0.34067 -6.16922,-0.56618 -7.7528,-0.82823 -15.47664,-2.1724 -22.98703,-3.98851 -11.41683,-2.74934 -22.61165,-6.67713 -33.23242,-11.58594 -14.51802,-6.71946 -28.19973,-15.42753 -40.43581,-25.79953 -7.62828,-6.4432 -14.85607,-13.65888 -21.31564,-21.27719 -9.09726,-10.71471 -16.94998,-22.48692 -23.31691,-35.01898 -2.61616,-5.14386 -5.07795,-10.63281 -7.20775,-16.10311 -3.47761,-8.92397 -6.2046,-18.13571 -8.21608,-27.49846 -0.33058,-1.58623 -0.70098,-3.39177 -1.00238,-5.07065 -1.20646,-6.55045 -2.04976,-13.27185 -2.53277,-19.84927 -0.42638,-6.00707 -0.55091,-11.96803 -0.39501,-18.01009 0.33631,-12.19796 1.9496,-24.49826 4.77791,-36.42757 4.65044,-19.67933 12.66764,-38.73323 23.68206,-55.77264 15.85725,-24.64111 37.78516,-45.34026 63.31199,-59.7311 2.10551,-1.18261 4.49073,-2.46086 6.63867,-3.56446 7.47948,-3.80949 15.22398,-7.10024 23.16406,-9.82422 13.4294,-4.5814 27.58121,-7.64056 41.78478,-8.96618 5.18776,-0.50384 10.27622,-0.74259 15.47499,-0.81116 z m 254.2329,179.56772 c -0.1599,40.14403 17.24969,39.50149 28.00827,40.08993 l -3.91192,159.12729 c 5.7279,15.54505 17.02967,15.04213 22.75764,0 l -3.91762,-159.46354 c 9.28858,-0.13135 27.75755,-0.19702 28.01412,-39.75295 l -4.43442,-78.33194 h -6.94147 v 67.53316 l -18.52599,0.0428 -0.91943,-67.57554 h -9.54296 l -0.84516,67.57554 -18.35713,-0.0428 v -67.53316 h -7.36683 l -4.01184,78.33194 z M 53.496724,392.97128 49.181283,567.05442 c 5.990933,14.08924 19.244229,14.18304 24.959614,0 L 69.825457,392.98731 C 120.32672,384.16851 107.69018,260.69727 61.664056,260.93778 19.183087,261.3355 5.1435556,385.79598 53.496243,392.9793 Z',
            $this->frameId()
        );
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(1%%, 1%%) scale(1.9);
        }

      

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
