<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class FurnitureShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'furniture';

    protected function symbolPath()
    {
        return 'm 647.44142,820.5682 c -5.89192,-10.46007 -10.91344,-19.49616 -11.15894,-20.0802 -0.2455,-0.58404 29.1304,-1.06189 65.27977,-1.06189 h 65.72613 v 20.08609 20.08608 l -54.56719,-0.006 -54.5672,-0.006 -10.71257,-19.0183 z m -489.4309,-1.04115 v -20.10094 h 66.38235 66.38235 l -4.38644,7.69967 c -2.41254,4.23481 -7.51254,13.1229 -11.33333,19.75131 l -6.94689,12.05165 -55.04902,0.34962 -55.04902,0.34963 z m 73.64897,-226.9876 V 539.6461 h 235.00718 235.00717 v 52.89335 52.89336 H 466.66667 231.65949 Z M 91.056911,632.89099 V 479.74659 L 81.007926,476.08151 C 51.345783,465.26313 27.476692,439.07889 18.483075,407.49215 14.614614,393.90562 14.345833,369.29796 17.9236,356.27067 c 8.619503,-31.38512 30.489799,-56.72735 59.489014,-68.93295 31.053456,-13.07022 67.483426,-9.60098 95.674376,9.1111 14.82157,9.838 30.28885,28.3529 37.25916,44.60061 1.51949,3.54189 3.91946,11.26047 5.33328,17.15239 2.45259,10.2209 2.57101,17.36557 2.57995,155.66714 l 0.009,144.95457 h 248.3979 248.39789 l 0.0233,-144.95457 c 0.0248,-154.55145 -0.0645,-152.24126 6.56225,-169.84282 15.03518,-39.93544 58.0906,-67.75249 100.54023,-64.9566 59.25231,3.90257 103.76223,57.85759 95.10562,115.28723 -5.57573,36.99054 -29.17884,66.81528 -64.21339,81.13966 l -10.80615,4.41824 V 632.97503 786.03539 H 466.66667 91.056911 Z M 231.65011,446.24582 c -0.009,-75.03222 -0.17387,-80.6957 -2.65358,-91.03892 -5.46664,-22.80209 -17.23609,-43.27564 -33.57208,-58.40026 l -9.44527,-8.74486 0.45963,-60.00411 c 0.44923,-58.64541 0.52953,-60.20119 3.54608,-68.70808 11.97189,-33.76157 37.38149,-56.56901 70.95002,-63.684123 7.40207,-1.568927 41.30539,-1.887797 202.7753,-1.907161 218.28645,-0.02618 204.58518,-0.64246 227.08931,10.214474 10.40011,5.01745 14.42903,7.93894 23.43376,16.99251 16.83045,16.92176 24.66931,32.79483 27.53546,55.75711 0.77899,6.24084 1.41634,34.47252 1.41634,62.73705 v 51.39007 l -8.79801,9.50268 c -17.25953,18.64186 -28.21408,41.92785 -31.29266,66.51846 -0.84739,6.76864 -1.42057,41.21249 -1.42057,85.36586 v 74.01886 H 466.66667 231.65949 l -0.009,-80.00956 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 484.27268,60.894692 c -92.34022,0.0012 -184.68074,-0.0076 -277.02079,0.0304 -18.92676,0.369972 -37.62094,7.854112 -51.55121,20.676996 -14.18036,12.904508 -23.42127,31.133372 -25.28285,50.230452 -0.51365,4.64162 -0.48395,9.31569 -0.43808,13.97828 0,21.69504 0,43.39008 0,65.08512 -6.67855,-3.30876 -13.51996,-6.4173 -20.78127,-8.21657 -18.142657,-4.7607 -37.845316,-3.35429 -55.102146,4.01232 -16.121255,6.78037 -30.052997,18.63632 -39.300969,33.4826 -8.5820936,13.68321 -13.2296626,29.81534 -13.0991486,45.97559 0.04111,15.50763 4.416458,30.96386 12.4873356,44.20394 8.781976,14.51872 22.003855,26.28164 37.415145,33.37181 2.478663,1.16513 5.044592,2.12609 7.592371,3.12682 0,77.42947 0,154.85893 0,232.2884 16.757485,0 33.514965,0 50.272452,0 0,13.32464 0,26.64929 0,39.97393 32.33253,0 64.66507,0 96.99759,0 7.57187,-13.32474 15.14412,-26.64927 22.71613,-39.97393 78.70955,0 157.41909,0 236.12863,0 7.57202,13.32466 15.14427,26.64919 22.71613,39.97393 32.30628,0 64.61254,0 96.91881,0 0,-13.32465 0,-26.64929 0,-39.97393 18.67592,0 37.35183,0 56.02775,0 0,-77.43081 0,-154.86162 0,-232.29243 9.65836,-3.53262 18.79326,-8.59497 26.64629,-15.26169 12.98533,-10.88798 22.66795,-25.68089 27.31581,-41.98676 4.65339,-15.97598 4.48624,-33.30193 -0.44152,-49.19287 -5.51178,-17.96508 -17.11675,-33.98858 -32.49017,-44.80111 -14.78849,-10.49859 -32.96806,-16.12127 -51.10491,-15.76137 -13.95718,0.23028 -27.8504,3.91686 -40.04098,10.73062 -1.49262,0.797 -2.97487,1.61261 -4.46091,2.42162 -0.0108,-25.27878 0.051,-50.55845 -0.0625,-75.83664 -0.54152,-16.09265 -6.14321,-31.97817 -15.88544,-44.805004 -9.77732,-13.040607 -23.71284,-22.887852 -39.26167,-27.769854 -7.9336,-2.541054 -16.27025,-3.726322 -24.59409,-3.696948 -0.77198,-0.0086 -1.54391,0.0025 -2.31587,0.0063 z m -275.32279,8.938987 c 93.34949,1.51e-4 186.69921,-0.005 280.04855,0.02616 18.93557,0.36752 37.55838,8.85465 50.23526,22.930387 11.27718,12.387314 17.94229,28.916434 18.18948,45.685034 0.12403,5.75005 -0.016,11.50213 0.0381,17.25309 0,21.34528 0,42.69058 0,64.03586 -12.19985,10.42701 -21.50542,24.25213 -26.32726,39.57649 -2.68679,8.49033 -4.16043,17.40113 -3.96025,26.31869 0,36.45315 0,72.9063 0,109.35945 -117.90842,-0.002 -235.81685,-0.004 -353.72528,-0.006 -8.4e-4,-38.31063 0.013,-76.62232 -0.0334,-114.93228 -1.17374,-18.72215 -8.74672,-36.96287 -21.15536,-51.03012 -3.94921,-4.51063 -8.41903,-8.55234 -13.17739,-12.18906 -0.0469,-26.49269 -0.16393,-52.98621 -0.10712,-79.47848 0.61684,-19.12096 9.5226,-37.817344 24.01604,-50.313128 12.29464,-10.721436 28.41391,-16.991364 44.74024,-17.211205 0.40612,-0.008 0.81223,-0.01799 1.21835,-0.02482 z M 612.25674,208.52028 c 20.18425,-0.10947 40.27893,8.14209 54.51362,22.46321 12.48497,12.44272 20.5323,29.27226 22.20877,46.83268 1.4324,14.43895 -1.28135,29.2805 -7.83866,42.23236 -0.53911,1.0316 -1.18922,2.29682 -1.82541,3.39236 -3.2615,5.74485 -7.28352,11.05225 -11.89518,15.7805 -0.77983,0.77719 -1.74688,1.7483 -2.636,2.5633 -1.74747,1.63276 -3.59684,3.19281 -5.42617,4.60301 -3.81754,2.95365 -7.91948,5.53771 -12.22782,7.71382 -0.91776,0.45572 -2.12305,1.02734 -3.12869,1.48413 -1.93413,0.90697 -3.98003,1.58627 -5.9078,2.48542 -1.05444,1.02162 -2.65099,0.96522 -3.93059,1.55343 -1.05842,0.12972 -2.2792,0.96634 -2.17995,2.20404 0.11287,3.57588 0.0171,7.1685 0.049,10.75092 0.002,72.54013 0.004,145.08025 0.006,217.62038 -187.9692,0 -375.9384,0 -563.907601,0 1e-6,-76.63354 0,-153.26709 0,-229.90063 -2.901214,-0.87427 -5.724395,-1.78427 -8.504663,-2.87259 -3.720103,-1.45354 -7.301119,-3.13024 -10.781382,-5.17249 -6.982033,-4.05854 -13.464644,-9.37132 -18.865749,-15.48516 -2.581483,-2.91022 -5.03676,-6.15836 -7.092606,-9.3329 -3.628979,-5.58838 -6.559177,-11.81558 -8.557186,-18.0618 -2.082458,-6.47452 -3.290263,-13.225 -3.615996,-20.01727 -0.0407,-0.90708 -0.07345,-2.11189 -0.08484,-3.1332 -0.136721,-14.52863 4.016034,-29.04771 11.767088,-41.33253 7.175627,-11.47949 17.435047,-21.00909 29.451178,-27.2547 3.317719,-1.7407 6.911274,-3.28134 10.355139,-4.4862 12.871836,-4.51606 26.952871,-5.52942 40.327158,-2.81918 3.59612,0.7122 7.29117,1.7371 10.65435,2.92827 11.03421,3.87357 21.14816,10.31783 29.31179,18.69208 0.7668,0.78656 1.70003,1.77607 2.49388,2.68091 7.27947,8.18743 12.81402,17.93201 16.03861,28.40656 0.28715,0.94252 0.63444,2.16445 0.91088,3.22529 0.87161,3.30321 1.53239,6.66761 1.92804,9.99758 0.66319,5.04676 0.35041,10.14253 0.4175,15.21502 0,67.32191 0,134.64383 0,201.96574 123.78963,0 247.57927,0 371.36891,0 0.008,-70.91727 -0.001,-141.83521 0.0193,-212.75206 0.45482,-7.63972 2.10139,-15.19942 4.80068,-22.35843 0.29909,-0.77393 0.70751,-1.83473 1.08285,-2.70433 5.35462,-12.8142 14.26284,-24.11476 25.50031,-32.27983 12.24912,-8.95814 27.18111,-14.21751 42.35703,-14.76178 0.89859,-0.0376 1.88847,-0.0585 2.84442,-0.0659 z m -85.46075,195.42745 c 0,26.95231 0,53.90461 0,80.85692 -117.7596,0.002 -235.51922,0.004 -353.27883,0.006 0,-26.95432 0,-53.90865 0,-80.86297 117.75961,0 235.51923,0 353.27883,0 z M 219.00195,599.14084 c -5.92969,10.34566 -11.85938,20.69132 -17.78909,31.03697 -27.57853,0 -55.15707,0 -82.73561,0 0,-10.34565 0,-20.69131 0,-31.03697 33.50823,0 67.01647,0 100.5247,0 z m 357.00594,0 c 0,10.34566 0,20.69132 0,31.03697 -27.57921,0 -55.15843,0 -82.73764,0 -5.8691,-10.34565 -11.73819,-20.69131 -17.60728,-31.03697 33.44831,0 66.89661,0 100.34492,0 z',
            $this->frameId()
        );
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf(
            '.foreground-0 {
            transform: translate(-4%%, -20.5%%) scale(2.5);
        }

        #%2$s path {
            transform: scale(0.75);
        }
        
        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%1$s);
        }',
            $this->maskId(),
            $this->symbolId(),
            $this->frameId(),
            $this->qrcode->design->frameColor
        );
    }

    protected function frameStrokeWidth()
    {
        return 1;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
