<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class GardeningShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'gardening';

    protected function symbolPath()
    {
        return
            'm 225.83183,477.71401 c -0.46443,-3.86657 -0.8521,-13.35724 -0.86149,-21.09038 -0.009,-7.73315 -0.40891,-21.74319 -0.88782,-31.13343 l -0.87076,-17.07317 h -4.66164 c -2.56391,0 -12.56418,2.23625 -22.22282,4.96945 -14.34539,4.05945 -19.76803,4.97052 -29.61281,4.97529 -10.43307,0.005 -12.95086,-0.46737 -18.74701,-3.51765 -13.70903,-7.2145 -23.76023,-22.05993 -29.02101,-42.8635 -1.47918,-5.84938 -2.38524,-10.93943 -2.01346,-11.31121 0.37179,-0.37178 1.89313,-0.0245 3.38077,0.7716 5.39452,2.88705 17.12093,1.62559 32.69998,-3.51771 26.40404,-8.71706 38.49403,-6.77988 53.76668,8.61506 7.51471,7.57488 9.47292,10.86873 5.12774,8.62523 -8.4593,-4.3677 -20.39118,-2.27814 -37.80172,6.62003 -8.20427,4.19303 -12.65813,5.65151 -17.55376,5.7482 -7.5442,0.14903 -8.547,1.47017 -2.22463,2.93087 7.61796,1.76002 18.74234,0.75284 30.36511,-2.74919 6.20582,-1.86988 13.30552,-3.39977 15.7771,-3.39977 5.83509,0 13.50092,3.24944 18.13326,7.68646 l 3.68245,3.52717 -0.005,-10.62834 c -0.003,-5.84559 -0.39529,-18.2721 -0.87178,-27.61447 l -0.86634,-16.98613 -6.38078,0.75572 c -5.57784,0.66061 -6.80446,0.33202 -9.74774,-2.61126 -4.55272,-4.55272 -6.52953,-12.68724 -5.53965,-22.79552 l 0.81576,-8.33029 -3.02454,4.01722 c -5.21365,6.92481 -12.81125,13.6692 -16.4183,14.5745 -5.93606,1.48987 -12.21633,-2.25939 -17.75313,-10.59841 -3.11529,-4.69197 -7.94986,-9.57791 -12.60562,-12.73958 -8.2662,-5.61347 -11.47202,-11.04549 -10.02564,-16.98766 0.49647,-2.03963 4.71526,-7.37975 9.3751,-11.8669 l 8.47243,-8.15846 -9.7948,0.62859 c -11.67904,0.74952 -15.68551,-0.0877 -19.37613,-4.04915 -2.49979,-2.6832 -2.73736,-4.44083 -2.48652,-18.39603 0.15253,-8.48616 -0.19527,-18.50688 -0.77288,-22.26827 -0.98545,-6.41717 -0.8,-7.11905 3.00741,-11.38211 3.86344,-4.32581 4.4955,-4.54323 13.20795,-4.54323 5.03268,0 10.92357,0.49257 13.09086,1.0946 3.35551,0.93208 2.51059,-0.26083 -5.69106,-8.03497 -8.48929,-8.0468 -9.63159,-9.70363 -9.63159,-13.96996 0,-5.94436 3.00623,-9.94442 12.3186,-16.391 4.27465,-2.95918 8.90641,-7.79412 11.64454,-12.15537 2.50063,-3.98296 6.48663,-8.28652 8.85778,-9.56347 4.16904,-2.24517 4.51305,-2.224 10.43405,0.64231 3.72595,1.8037 8.09815,5.5542 11.1687,9.58056 2.7752,3.63909 5.21561,6.61653 5.42313,6.61653 0.20751,0 0.0428,-4.36872 -0.36595,-9.70827 -0.59739,-7.80311 -0.26556,-10.62771 1.69092,-14.39349 3.66441,-7.05317 8.1016,-8.61145 19.64319,-6.89843 6.95974,1.03298 12.0152,0.99837 18.57881,-0.12716 10.57775,-1.81388 14.87811,-0.72954 18.97734,4.78516 2.37922,3.20079 2.78863,5.53254 2.64505,15.06457 -0.0935,6.20269 -0.045,11.27762 0.1078,11.27762 0.1527,0 2.1914,-2.66486 4.53044,-5.92191 11.07604,-15.42312 22.76994,-15.10512 32.88301,0.89418 2.29493,3.63068 6.46822,7.52224 10.92646,10.18883 15.49059,9.26533 15.39039,18.15477 -0.36393,32.28613 -4.51346,4.04849 -6.62494,6.66981 -5.06357,6.28619 12.65524,-3.10925 23.61789,-1.84063 28.24264,3.26829 2.71548,2.99976 3.23029,12.05683 1.20182,21.14343 -0.58856,2.63644 -0.29362,8.35358 0.70362,13.63869 1.40396,7.4407 1.39922,9.86652 -0.026,13.30722 -2.95404,7.13169 -6.47202,8.47767 -20.12362,7.69929 -6.60392,-0.37654 -12.00711,-0.53959 -12.00711,-0.36234 0,0.17727 2.78106,2.489 6.18015,5.13721 11.72678,9.13625 15.17801,17.09483 10.50553,24.22593 -1.13374,1.73029 -5.32647,5.31392 -9.31718,7.96361 -4.57194,3.0356 -8.98895,7.52688 -11.94121,12.142 -9.00785,14.08153 -16.80277,14.57209 -29.25977,1.84137 l -7.76987,-7.94061 0.86713,8.46377 c 1.02067,9.96224 -1.28129,16.99358 -6.73287,20.56558 -2.71335,1.77786 -5.30278,2.13161 -11.49396,1.57021 l -7.99156,-0.72464 v 9.14 c 0,9.25422 1.99547,43.10329 3.46041,58.69855 l 0.7988,8.5038 3.56145,-3.32941 c 9.12654,-8.53193 17.59956,-9.55055 35.12843,-4.2231 8.71778,2.64954 13.48095,3.32917 20.9485,2.98906 11.27293,-0.51342 15.84981,-3.01856 5.78419,-3.16594 -4.91153,-0.0719 -9.73938,-1.66481 -19.68255,-6.49402 -14.35772,-6.97326 -24.91514,-9.00844 -32.68326,-6.30047 -2.39774,0.83585 -4.58788,1.29139 -4.86697,1.0123 -0.27909,-0.27909 2.56635,-3.87064 6.3232,-7.98123 14.63721,-16.01545 28.04049,-18.43154 54.33454,-9.79442 15.30529,5.02751 25.24763,6.11243 32.10897,3.50375 1.99131,-0.75709 3.89094,-1.10615 4.2214,-0.77569 1.2301,1.23009 -5.20993,22.74682 -9.34899,31.23576 -7.88693,16.17565 -20.18477,25.38385 -35.79087,26.79896 -9.18595,0.83295 -19.31105,-0.87523 -38.08454,-6.42518 -15.56927,-4.60269 -20.86745,-5.00591 -20.83244,-1.58548 0.0133,1.28886 1.51299,13.18987 3.33289,26.44668 1.81989,13.25682 3.31555,24.85653 3.32369,25.77714 0.0104,1.18882 -2.84133,1.67384 -9.84172,1.67384 h -9.85652 z m 3.81905,-154.05008 c 1.47298,-0.0427 5.48092,0.38865 8.90653,0.95867 5.44364,0.9058 6.60477,0.65997 9.21584,-1.95108 2.65055,-2.65056 2.89982,-3.91127 2.21035,-11.17955 -0.4495,-4.73839 -4.33481,-18.63611 -9.21584,-32.96495 -7.17643,-21.06721 -8.83934,-24.77284 -11.11688,-24.77284 -2.28135,0 -3.9127,3.6703 -11.01089,24.77284 -9.57167,28.4561 -11.3151,38.24556 -7.77381,43.65026 2.19354,3.34776 2.735,3.49815 9.21849,2.56052 3.78844,-0.54788 8.09324,-1.03113 9.56621,-1.07387 z m 55.10485,-17.74949 c 5.59636,-6.96963 8.81423,-10.20643 14.30445,-14.38855 10.94181,-8.33481 4.06758,-16.01662 -29.04931,-32.46193 -22.73296,-11.28883 -28.97787,-13.28281 -28.97787,-9.25254 0,4.22759 24.32426,50.26027 29.34969,55.5431 6.24433,6.56415 9.45152,6.68909 14.37304,0.55992 z m -94.73491,-1.69542 c 4.70484,-4.99068 28.24795,-50.42851 28.24795,-54.5181 0,-3.87395 -6.29988,-1.84714 -28.80011,9.26561 -37.1544,18.35038 -41.61817,25.33918 -23.76992,37.21589 1.65081,1.09849 4.81815,4.50512 7.03853,7.57027 5.47371,7.55622 10.47257,7.69111 17.28355,0.46633 z M 168.08048,253.1301 c 13.3411,-3.75784 42.18234,-14.2681 43.91916,-16.00492 2.71542,-2.71542 -1.98824,-5.13804 -25.19907,-12.97878 -18.98611,-6.4136 -24.36318,-7.70617 -32.39841,-7.78805 -11.51052,-0.11731 -13.20886,1.0938 -12.55998,8.95664 0.61784,7.48667 0.62101,13.64128 0.0111,21.48283 -0.35974,4.62505 0.053,6.7844 1.4678,7.67916 3.27596,2.07182 14.85942,1.44169 24.75942,-1.34688 z m 148.60656,-0.52165 c 1.71764,-2.62146 1.81722,-4.31811 0.58944,-10.04304 -1.0771,-5.02235 -1.0771,-8.75505 0,-13.7774 1.22778,-5.72493 1.1282,-7.42158 -0.58944,-10.04304 -1.80566,-2.75577 -3.1236,-3.15434 -10.43018,-3.15434 -6.70624,0 -13.13423,1.61544 -32.44163,8.15302 -13.24304,4.48417 -24.98214,9.04037 -26.08687,10.12489 -1.78402,1.75137 -1.74475,2.16771 0.3512,3.72349 2.24193,1.66413 36.56233,13.95358 46.51633,16.65655 2.57771,0.69997 8.13771,1.32702 12.35555,1.39344 6.64814,0.10469 7.94386,-0.29904 9.7356,-3.03357 z m -99.03749,-32.60732 c -1.26443,-5.03792 -20.44294,-43.16311 -24.42701,-48.55876 -8.60819,-11.65814 -14.24463,-12.49131 -20.66067,-3.05404 -2.37837,3.49833 -5.15516,6.86274 -6.17065,7.47648 -4.91257,2.96908 -11.05884,9.47026 -11.05884,11.69742 0,6.86916 13.77839,16.82268 38.97727,28.1572 22.50274,10.12179 24.91683,10.56465 23.3399,4.2817 z m 48.48969,-4.82873 c 18.56471,-8.38547 33.76642,-17.92445 36.39633,-22.83849 2.74203,-5.12353 0.80001,-9.86003 -5.63684,-13.74803 -3.10858,-1.87765 -7.45938,-6.08838 -9.66845,-9.35718 -6.99926,-10.35692 -13.7738,-9.27859 -22.26141,3.54343 -6.79073,10.25858 -24.3701,47.78989 -23.47589,50.12016 0.97533,2.54167 4.08325,1.56818 24.64626,-7.71989 z m -26.08078,-19.49462 c 9.38745,-26.59268 11.86418,-38.87175 8.89961,-44.12222 -1.74401,-3.08877 -2.85566,-3.57107 -7.98842,-3.46586 -3.27936,0.0672 -7.46893,0.29792 -9.31016,0.51267 -1.84122,0.21475 -6.4427,-0.0594 -10.2255,-0.6093 -6.08492,-0.88449 -7.22378,-0.65378 -9.87879,2.00123 -2.62395,2.62395 -2.91257,3.97588 -2.29733,10.76091 0.59849,6.60022 13.53221,47.85138 17.32316,55.25097 2.9807,5.81805 5.69018,1.73127 13.47743,-20.3284 z m 154.4802,118.38595 c -7.39662,-6.85496 -7.74932,-12.16671 -2.03702,-30.67778 3.36736,-10.91214 5.14249,-14.48719 9.21597,-18.56067 4.3775,-4.3775 5.86367,-5.04527 11.22863,-5.04527 3.40085,0 6.18336,0.29409 6.18336,0.65352 0,0.35944 -1.76383,6.23462 -3.91962,13.05596 -2.15579,6.82133 -6.10606,19.48277 -8.77838,28.13653 -2.93756,9.51268 -5.54624,15.73409 -6.59742,15.73409 -0.95627,0 -3.33925,-1.48337 -5.29552,-3.29638 z m 105.41576,16.16586 -69.82081,-24.33949 3.24485,-10.29181 c 3.13284,-9.93657 3.37046,-10.26608 6.88441,-9.54664 2.00176,0.40984 28.30468,6.26609 58.45092,13.0139 l 54.81136,12.26874 9.12935,20.7031 c 9.21739,20.9028 9.9447,22.93247 8.12503,22.67421 -0.55237,-0.0784 -32.42367,-11.0953 -70.82511,-24.48201 z m 126.06041,86.80132 c -2.92445,-6.5632 -4.57658,-11.88239 -3.88332,-12.50272 1.42387,-1.27407 201.06296,-108.0905 204.22991,-109.27273 1.61074,-0.6013 3.87135,1.88436 8.86019,9.74227 l 6.69772,10.54953 -95.89988,51.44988 c -52.74494,28.29744 -100.17822,53.70145 -105.40729,56.45335 l -9.5074,5.00347 z m 207.78506,-158.48646 -3.47612,-5.25279 5.84737,-8.71997 c 8.59886,-12.82315 11.67523,-21.99905 12.46935,-37.19241 1.14618,-21.92903 -4.56244,-37.79398 -19.1717,-53.28057 -16.87468,-17.88805 -41.55901,-25.88921 -64.76807,-20.99386 -5.47391,1.15458 -10.05103,1.95808 -10.17138,1.78557 -3.59111,-5.14769 -7.32704,-11.17968 -7.32704,-11.83016 0,-0.46848 3.76614,-1.97252 8.3692,-3.34231 13.2878,-3.95423 34.78707,-3.3566 48.52851,1.34898 14.55876,4.98546 25.12301,11.61131 35.62784,22.34561 15.77019,16.11467 24.26489,36.89862 24.3009,59.4569 0.0229,14.32782 -2.68254,25.88342 -9.09165,38.83309 -4.3984,8.88703 -14.32395,22.0947 -16.60414,22.0947 -0.58131,0 -2.6212,-2.36376 -4.53307,-5.25278 z M 530.97072,200.14041 c -2.04647,-4.81517 -3.44445,-9.03126 -3.10662,-9.36909 0.66123,-0.66123 156.91556,-84.49403 167.40063,-89.81296 l 6.31207,-3.202032 5.40215,7.955022 c 3.95897,5.82983 4.95569,8.23331 3.73098,8.99672 -2.04345,1.27375 -175.44694,94.1872 -175.78068,94.1872 -0.13072,0 -1.91205,-3.93969 -3.95853,-8.75486 z m 46.91432,107.09253 c -18.23683,-41.65952 -32.9453,-75.95614 -32.68549,-76.2147 0.25981,-0.25857 37.22991,-20.15127 82.15578,-44.20601 44.92588,-24.05475 85.3361,-45.72519 89.80052,-48.15655 l 8.1171,-4.42065 43.73498,67.92295 c 24.05424,37.35762 44.08159,68.82617 44.50521,69.93011 0.58681,1.5292 -21.16747,13.75325 -91.35472,51.33366 -50.66872,27.12956 -96.39782,51.62807 -101.62023,54.44113 l -9.49529,5.11464 z m -415.13281,301.38593 74.45998,277.97122 c 1.77674,6.65672 8.80184,12.04406 15.68808,12.04406 h 267.6795 c 6.89001,0 13.90326,-5.38755 15.69228,-12.04406 l 74.46836,-277.97122 z m -18.28827,-17.6909 h 484.55007 c 3.45118,0 6.67716,-2.75926 7.20526,-6.15722 l 14.54992,-93.1811 c 0.5322,-3.39794 -1.83816,-6.1613 -5.26472,-6.1613 H 127.98314 c -3.44711,0 -5.80928,2.76336 -5.2688,6.1613 l 14.5541,93.1811 c 0.52812,3.40613 3.75407,6.15722 7.19709,6.15722 z';
    }

    protected function frameNode()
    {
        return $this->makeMultiplePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            [
                'm 662.0886,176.23808 c 6.3711,-21.059 4.168,-43.316 -6.1953,-62.664 -20.504,-38.272994 -67.129,-53.671994 -106.16,-36.151994 l -9.207,-14.32 c -4.6797,-7.2812 -14.328,-9.793 -21.961,-5.6992 L 386.52529,128.12988 c -7.6328,4.0898 -10.898,13.508 -7.4297,21.441 l 28.145,64.336 -75.547,-16.836 c 0.33594,-3.3789 -0.30859,-6.7852 -1.9219,-9.8633 -2.1797,-4.1445 -5.8438,-7.1953 -10.316,-8.5859 -7.9688,-2.4844 -16.422,-1.7031 -23.812,2.1758 -7.3867,3.8828 -12.816,10.41 -15.293,18.379 l -5.2383,16.84 c -5.1094,16.449 4.1094,33.992 20.555,39.102 1.7188,0.53516 3.4805,0.80078 5.2344,0.80078 2.8047,0 5.582,-0.67969 8.1367,-2.0195 3.4453,-1.8125 6.0664,-4.6836 7.6758,-8.1602 l 123.13,42.691 17.76201,40.609 c 1.8594,4.2656 5.4531,7.5781 9.8438,9.1055 1.7734,0.61328 3.6211,0.91406 5.4688,0.91406 2.7305,0 5.4531,-0.66016 7.9023,-1.9727 l 159.45,-85.41 c 4.1016,-2.1953 7.1211,-6.0391 8.2891,-10.539 1.1719,-4.5039 0.3984,-9.3281 -2.1172,-13.246 l -8.8086,-13.703 c 11.434,-10.02 19.938,-23.008 24.457,-37.949 z m -360.51001,62.359 c -0.10547,0.32812 -0.59766,0.58984 -0.92578,0.48047 -7.5977,-2.3633 -11.863,-10.469 -9.5,-18.07 l 5.2383,-16.84 c 1.1445,-3.6836 3.6602,-6.6992 7.0703,-8.4922 2.1016,-1.1055 4.3906,-1.6641 6.6992,-1.6641 1.4414,0 2.8906,0.21484 4.3086,0.65625 0.33203,0.10547 0.58594,0.58984 0.48047,0.92578 z m 99.309,-80.973 -6.4297,-14.684 131.98001,-70.694994 8.6719,13.48 z m -78.973,72.145 5.1367,-16.52 88.531,19.73 15.09,34.5 z m 136.08001,58.281 -50.34801,-114.99 136.58001,-73.163994 67.922,105.579994 z m 117.15,-171.1 c 2.668,-0.62109 5.3867,-0.96484 8.125,-0.96484 3.5508,0 7.125,0.52344 10.625,1.582 9.3281,2.8203 16.992,9.0938 21.578,17.656 6.9688,13.008 5.1797,28.387 -3.2656,39.402 z m -102.14,205.36 -8.2422,-18.828 156.51,-83.832 11.074,17.215 z m 155.44,-122.44 -6.7617,-10.52 c 15.582,-16.195 19.777,-41.219 8.6094,-62.066 -6.7031,-12.52 -17.906,-21.68 -31.527,-25.801 -10.988,-3.328094 -22.461,-2.980494 -33.059,0.76953 l -6.793,-10.565994 c 30.566,-12.324 66.266,0.10547 82.176,29.815994 8.2461,15.391 9.9961,33.098 4.9219,49.867 -3.3398,11.062 -9.4258,20.773 -17.566,28.5 z',

                'm 225.83183,477.71401 c -0.46443,-3.86657 -0.8521,-13.35724 -0.86149,-21.09038 -0.009,-7.73315 -0.40891,-21.74319 -0.88782,-31.13343 l -0.87076,-17.07317 h -4.66164 c -2.56391,0 -12.56418,2.23625 -22.22282,4.96945 -14.34539,4.05945 -19.76803,4.97052 -29.61281,4.97529 -10.43307,0.005 -12.95086,-0.46737 -18.74701,-3.51765 -13.70903,-7.2145 -23.76023,-22.05993 -29.02101,-42.8635 -1.47918,-5.84938 -2.38524,-10.93943 -2.01346,-11.31121 0.37179,-0.37178 1.89313,-0.0245 3.38077,0.7716 5.39452,2.88705 17.12093,1.62559 32.69998,-3.51771 26.40404,-8.71706 38.49403,-6.77988 53.76668,8.61506 7.51471,7.57488 9.47292,10.86873 5.12774,8.62523 -8.4593,-4.3677 -20.39118,-2.27814 -37.80172,6.62003 -8.20427,4.19303 -12.65813,5.65151 -17.55376,5.7482 -7.5442,0.14903 -8.547,1.47017 -2.22463,2.93087 7.61796,1.76002 18.74234,0.75284 30.36511,-2.74919 6.20582,-1.86988 13.30552,-3.39977 15.7771,-3.39977 5.83509,0 13.50092,3.24944 18.13326,7.68646 l 3.68245,3.52717 -0.005,-10.62834 c -0.003,-5.84559 -0.39529,-18.2721 -0.87178,-27.61447 l -0.86634,-16.98613 -6.38078,0.75572 c -5.57784,0.66061 -6.80446,0.33202 -9.74774,-2.61126 -4.55272,-4.55272 -6.52953,-12.68724 -5.53965,-22.79552 l 0.81576,-8.33029 -3.02454,4.01722 c -5.21365,6.92481 -12.81125,13.6692 -16.4183,14.5745 -5.93606,1.48987 -12.21633,-2.25939 -17.75313,-10.59841 -3.11529,-4.69197 -7.94986,-9.57791 -12.60562,-12.73958 -8.2662,-5.61347 -11.47202,-11.04549 -10.02564,-16.98766 0.49647,-2.03963 4.71526,-7.37975 9.3751,-11.8669 l 8.47243,-8.15846 -9.7948,0.62859 c -11.67904,0.74952 -15.68551,-0.0877 -19.37613,-4.04915 -2.49979,-2.6832 -2.73736,-4.44083 -2.48652,-18.39603 0.15253,-8.48616 -0.19527,-18.50688 -0.77288,-22.26827 -0.98545,-6.41717 -0.8,-7.11905 3.00741,-11.38211 3.86344,-4.32581 4.4955,-4.54323 13.20795,-4.54323 5.03268,0 10.92357,0.49257 13.09086,1.0946 3.35551,0.93208 2.51059,-0.26083 -5.69106,-8.03497 -8.48929,-8.0468 -9.63159,-9.70363 -9.63159,-13.96996 0,-5.94436 3.00623,-9.94442 12.3186,-16.391 4.27465,-2.95918 8.90641,-7.79412 11.64454,-12.15537 2.50063,-3.98296 6.48663,-8.28652 8.85778,-9.56347 4.16904,-2.24517 4.51305,-2.224 10.43405,0.64231 3.72595,1.8037 8.09815,5.5542 11.1687,9.58056 2.7752,3.63909 5.21561,6.61653 5.42313,6.61653 0.20751,0 0.0428,-4.36872 -0.36595,-9.70827 -0.59739,-7.80311 -0.26556,-10.62771 1.69092,-14.39349 3.66441,-7.05317 8.1016,-8.61145 19.64319,-6.89843 6.95974,1.03298 12.0152,0.99837 18.57881,-0.12716 10.57775,-1.81388 14.87811,-0.72954 18.97734,4.78516 2.37922,3.20079 2.78863,5.53254 2.64505,15.06457 -0.0935,6.20269 -0.045,11.27762 0.1078,11.27762 0.1527,0 2.1914,-2.66486 4.53044,-5.92191 11.07604,-15.42312 22.76994,-15.10512 32.88301,0.89418 2.29493,3.63068 6.46822,7.52224 10.92646,10.18883 15.49059,9.26533 15.39039,18.15477 -0.36393,32.28613 -4.51346,4.04849 -6.62494,6.66981 -5.06357,6.28619 12.65524,-3.10925 23.61789,-1.84063 28.24264,3.26829 2.71548,2.99976 3.23029,12.05683 1.20182,21.14343 -0.58856,2.63644 -0.29362,8.35358 0.70362,13.63869 1.40396,7.4407 1.39922,9.86652 -0.026,13.30722 -2.95404,7.13169 -6.47202,8.47767 -20.12362,7.69929 -6.60392,-0.37654 -12.00711,-0.53959 -12.00711,-0.36234 0,0.17727 2.78106,2.489 6.18015,5.13721 11.72678,9.13625 15.17801,17.09483 10.50553,24.22593 -1.13374,1.73029 -5.32647,5.31392 -9.31718,7.96361 -4.57194,3.0356 -8.98895,7.52688 -11.94121,12.142 -9.00785,14.08153 -16.80277,14.57209 -29.25977,1.84137 l -7.76987,-7.94061 0.86713,8.46377 c 1.02067,9.96224 -1.28129,16.99358 -6.73287,20.56558 -2.71335,1.77786 -5.30278,2.13161 -11.49396,1.57021 l -7.99156,-0.72464 v 9.14 c 0,9.25422 1.99547,43.10329 3.46041,58.69855 l 0.7988,8.5038 3.56145,-3.32941 c 9.12654,-8.53193 17.59956,-9.55055 35.12843,-4.2231 8.71778,2.64954 13.48095,3.32917 20.9485,2.98906 11.27293,-0.51342 15.84981,-3.01856 5.78419,-3.16594 -4.91153,-0.0719 -9.73938,-1.66481 -19.68255,-6.49402 -14.35772,-6.97326 -24.91514,-9.00844 -32.68326,-6.30047 -2.39774,0.83585 -4.58788,1.29139 -4.86697,1.0123 -0.27909,-0.27909 2.56635,-3.87064 6.3232,-7.98123 14.63721,-16.01545 28.04049,-18.43154 54.33454,-9.79442 15.30529,5.02751 25.24763,6.11243 32.10897,3.50375 1.99131,-0.75709 3.89094,-1.10615 4.2214,-0.77569 1.2301,1.23009 -5.20993,22.74682 -9.34899,31.23576 -7.88693,16.17565 -20.18477,25.38385 -35.79087,26.79896 -9.18595,0.83295 -19.31105,-0.87523 -38.08454,-6.42518 -15.56927,-4.60269 -20.86745,-5.00591 -20.83244,-1.58548 0.0133,1.28886 1.51299,13.18987 3.33289,26.44668 1.81989,13.25682 3.31555,24.85653 3.32369,25.77714 0.0104,1.18882 -2.84133,1.67384 -9.84172,1.67384 h -9.85652 z m 3.81905,-154.05008 c 1.47298,-0.0427 5.48092,0.38865 8.90653,0.95867 5.44364,0.9058 6.60477,0.65997 9.21584,-1.95108 2.65055,-2.65056 2.89982,-3.91127 2.21035,-11.17955 -0.4495,-4.73839 -4.33481,-18.63611 -9.21584,-32.96495 -7.17643,-21.06721 -8.83934,-24.77284 -11.11688,-24.77284 -2.28135,0 -3.9127,3.6703 -11.01089,24.77284 -9.57167,28.4561 -11.3151,38.24556 -7.77381,43.65026 2.19354,3.34776 2.735,3.49815 9.21849,2.56052 3.78844,-0.54788 8.09324,-1.03113 9.56621,-1.07387 z m 55.10485,-17.74949 c 5.59636,-6.96963 8.81423,-10.20643 14.30445,-14.38855 10.94181,-8.33481 4.06758,-16.01662 -29.04931,-32.46193 -22.73296,-11.28883 -28.97787,-13.28281 -28.97787,-9.25254 0,4.22759 24.32426,50.26027 29.34969,55.5431 6.24433,6.56415 9.45152,6.68909 14.37304,0.55992 z m -94.73491,-1.69542 c 4.70484,-4.99068 28.24795,-50.42851 28.24795,-54.5181 0,-3.87395 -6.29988,-1.84714 -28.80011,9.26561 -37.1544,18.35038 -41.61817,25.33918 -23.76992,37.21589 1.65081,1.09849 4.81815,4.50512 7.03853,7.57027 5.47371,7.55622 10.47257,7.69111 17.28355,0.46633 z M 168.08048,253.1301 c 13.3411,-3.75784 42.18234,-14.2681 43.91916,-16.00492 2.71542,-2.71542 -1.98824,-5.13804 -25.19907,-12.97878 -18.98611,-6.4136 -24.36318,-7.70617 -32.39841,-7.78805 -11.51052,-0.11731 -13.20886,1.0938 -12.55998,8.95664 0.61784,7.48667 0.62101,13.64128 0.0111,21.48283 -0.35974,4.62505 0.053,6.7844 1.4678,7.67916 3.27596,2.07182 14.85942,1.44169 24.75942,-1.34688 z m 148.60656,-0.52165 c 1.71764,-2.62146 1.81722,-4.31811 0.58944,-10.04304 -1.0771,-5.02235 -1.0771,-8.75505 0,-13.7774 1.22778,-5.72493 1.1282,-7.42158 -0.58944,-10.04304 -1.80566,-2.75577 -3.1236,-3.15434 -10.43018,-3.15434 -6.70624,0 -13.13423,1.61544 -32.44163,8.15302 -13.24304,4.48417 -24.98214,9.04037 -26.08687,10.12489 -1.78402,1.75137 -1.74475,2.16771 0.3512,3.72349 2.24193,1.66413 36.56233,13.95358 46.51633,16.65655 2.57771,0.69997 8.13771,1.32702 12.35555,1.39344 6.64814,0.10469 7.94386,-0.29904 9.7356,-3.03357 z m -99.03749,-32.60732 c -1.26443,-5.03792 -20.44294,-43.16311 -24.42701,-48.55876 -8.60819,-11.65814 -14.24463,-12.49131 -20.66067,-3.05404 -2.37837,3.49833 -5.15516,6.86274 -6.17065,7.47648 -4.91257,2.96908 -11.05884,9.47026 -11.05884,11.69742 0,6.86916 13.77839,16.82268 38.97727,28.1572 22.50274,10.12179 24.91683,10.56465 23.3399,4.2817 z m 48.48969,-4.82873 c 18.56471,-8.38547 33.76642,-17.92445 36.39633,-22.83849 2.74203,-5.12353 0.80001,-9.86003 -5.63684,-13.74803 -3.10858,-1.87765 -7.45938,-6.08838 -9.66845,-9.35718 -6.99926,-10.35692 -13.7738,-9.27859 -22.26141,3.54343 -6.79073,10.25858 -24.3701,47.78989 -23.47589,50.12016 0.97533,2.54167 4.08325,1.56818 24.64626,-7.71989 z m -26.08078,-19.49462 c 9.38745,-26.59268 11.86418,-38.87175 8.89961,-44.12222 -1.74401,-3.08877 -2.85566,-3.57107 -7.98842,-3.46586 -3.27936,0.0672 -7.46893,0.29792 -9.31016,0.51267 -1.84122,0.21475 -6.4427,-0.0594 -10.2255,-0.6093 -6.08492,-0.88449 -7.22378,-0.65378 -9.87879,2.00123 -2.62395,2.62395 -2.91257,3.97588 -2.29733,10.76091 0.59849,6.60022 13.53221,47.85138 17.32316,55.25097 2.9807,5.81805 5.69018,1.73127 13.47743,-20.3284 z',

                'm 162.75223,608.61887 74.45998,277.97122 c 1.77674,6.65672 8.80184,12.04406 15.68808,12.04406 h 267.6795 c 6.89001,0 13.90326,-5.38755 15.69228,-12.04406 l 74.46836,-277.97122 z m -18.28827,-17.6909 h 484.55007 c 3.45118,0 6.67716,-2.75926 7.20526,-6.15722 l 14.54992,-93.1811 c 0.5322,-3.39794 -1.83816,-6.1613 -5.26472,-6.1613 H 127.98314 c -3.44711,0 -5.80928,2.76336 -5.2688,6.1613 l 14.5541,93.1811 c 0.52812,3.40613 3.75407,6.15722 7.19709,6.15722 z'
            ],
            $this->frameId()
        );
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf(
            '.foreground-0 {
            transform: translate(-5%%, 34%%) scale(1.7);
        }

        #%2$s path {
            transform: scale(0.75);
        }
        
        #%3$s {
            fill: none;
            stroke: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }
        
        #%5$s path:nth-child(2), 
        #%5$s path:nth-child(3) {
            transform: scale(0.75);
        }
        
        ',
            $this->maskId(),
            $this->symbolId(),
            $this->frameId(),
            $this->qrcode->design->frameColor,
            'symbol-frame-' . $this::$shapeId,
        );
    }

    protected function frameStrokeWidth()
    {
        return 6;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
