<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

use SVG\Nodes\Shapes\SVGPath;
use SVG\Nodes\Structures\SVGSymbol;

class GymShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'gym';

    protected function symbolPath()
    {
        return 'm 811.47776,736.48972 c 0,-35.21642 -1.06891,-32.86501 12.7747,-28.10211 14.73667,5.07016 14.00675,3.60551 14.00675,28.10576 v 21.36707 l -5.02152,2.55765 c -4.6711,2.37916 -18.17915,6.87029 -20.6639,6.87029 -0.60282,0 -1.09603,-13.8594 -1.09603,-30.79866 z m -64.27546,1.30593 c 0,-75.8093 0.46646,-117.80521 1.3085,-117.80521 4.84045,0 31.00651,12.00621 35.85075,16.44999 l 3.01291,2.76385 v 96.75183 96.75182 l -5.02152,4.14651 c -4.76145,3.93176 -23.89595,14.46739 -31.58357,17.39022 l -3.56707,1.3562 z m -77.3781,166.79897 c -4.62874,-1.05093 -10.95586,-3.3119 -14.06026,-5.02436 l -5.64438,-3.11357 -0.34013,-161.50937 -0.34013,-161.50937 3.08708,-2.02273 c 9.46731,-6.20322 31.86174,-9.73062 48.58418,-7.65261 10.87161,1.35095 28.73094,6.6211 32.20336,9.50295 1.53756,1.27606 1.83673,27.67356 1.83673,162.06873 v 160.54439 l -4.35199,2.6797 c -8.14097,5.01275 -17.12937,6.91525 -35.15064,7.44007 -11.93608,0.34761 -20.05332,-0.0936 -25.82382,-1.40383 z M 299.95218,737.15925 v -32.80727 h 168.72309 168.7231 v 32.80727 32.80727 H 468.67527 299.95218 Z m 43.95137,-2.42435 c 0.71075,-6.19858 -1.62882,-7.61869 -12.55149,-7.61869 -12.46382,0 -16.16956,2.80251 -12.57844,9.51259 1.2673,2.36797 2.61774,2.60125 13.05595,2.25534 l 11.64245,-0.38581 z m 49.54567,0 c 0.76871,-6.70407 -1.30074,-7.61869 -17.23824,-7.61869 -11.36928,0 -14.92112,0.45094 -16.57444,2.10426 -2.47376,2.47375 -2.60207,3.837 -0.69631,7.39794 1.29946,2.42806 2.66662,2.60185 17.74271,2.25535 l 16.33475,-0.37543 z m 228.72149,0.87802 c 2.07725,-8.27641 8.2979,-7.79369 -105.28746,-8.17025 -75.33833,-0.24976 -103.98035,0.068 -105.3061,1.16827 -1.87985,1.56014 -2.50671,8.08584 -0.92834,9.66421 0.491,0.49099 48.08353,0.89271 105.76119,0.89271 H 621.27849 Z M 221.235,904.59462 c -4.62873,-1.05093 -10.95585,-3.31191 -14.06026,-5.0244 l -5.64437,-3.11362 V 735.16713 573.87765 l 5.35629,-3.01553 c 8.31864,-4.6833 22.29016,-7.29023 38.80655,-7.24087 15.96663,0.0477 27.15696,2.29053 36.13286,7.24192 l 5.40492,2.98152 V 734.4539 895.06309 l -4.5684,3.07865 c -7.85518,5.29361 -17.01737,7.31543 -35.60377,7.85671 -11.93607,0.34761 -20.05331,-0.0936 -25.82382,-1.40383 z m -42.46886,-52.78345 c -13.86992,-5.41244 -26.407,-11.85533 -31.93391,-16.41108 l -4.89058,-4.03123 v -95.52713 -95.52714 l 4.35199,-3.67754 c 2.39359,-2.02265 7.66619,-5.16374 11.71688,-6.98019 8.6268,-3.86853 29.71879,-11.19266 30.3667,-10.54475 0.24562,0.24563 0.29265,53.52641 0.10451,118.40172 l -0.34208,117.95513 z m -66.28407,-86.56572 c -3.31421,-0.85247 -8.5868,-2.86284 -11.71689,-4.46748 l -5.691053,-2.91753 v -21.32201 c 0,-20.45643 0.119709,-21.40585 2.948834,-23.38745 3.422769,-2.3974 19.694729,-8.02695 20.596119,-7.12556 0.3353,0.3353 0.44745,14.14572 0.24922,30.68981 l -0.36041,30.08016 z M 223.80053,14.614259 H 709.5328 V 500.34652 H 223.80053 Z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 607.91854,511.48212 v -32.34 c 0,-15.309 -23.039,-25.082 -37.832,-29.773 l 0.0547,-15.785 c 0,-19.809 -25.867,-28.672 -51.496,-28.672 -30.566,0 -49.97992,11.06917 -50.309,28.172 v 77.957 h -234.67 v -77.965 c 0,-17.051 -19.66,-28.074 -50.094,-28.074 -25.766,0 -51.762,8.8945 -51.762,28.777 l 0.004,14.84 c -18.08202,5.2969 -42.234019,15.242 -42.234019,30.559 l 0.17188,32.543 c -13.809,1.668 -35.531,8.7148 -35.531,23.195 v 34.574 c 0,14.539 21.887,21.582 35.684,23.219 l -0.32422,31.41 c 0,15.109 24.347999,26.426 42.352019,32.723 v 12.156 c 0,20.066 22.473,28.422 50.863,28.422 25.316,0 50.863,-8.7852 50.863,-28.422 v -73.977 l 234.66,-0.0117 v 73.988 c 0,19.633 25.547,28.422 50.863,28.422 25.316,0 50.863,-8.7852 50.863,-28.422 v -12.395 c 14.566,-5.7695 37.863,-17.371 37.863,-32.484 v -31.191 c 13.531,-1.1094 37.863,-8.1016 37.863,-23.438 l 0.008,-34.57 c -0.004,-15.336 -24.336,-22.328 -37.867,-23.438 z m -517.830019,64.348 c -8.293,-1.25 -16.895,-4.8086 -19.059,-7.2539 v -32.762 c 2.1445,-2.418 10.602,-5.9414 18.82,-7.2109 z m 16.300999,47.965 v -144.27 c 2.1719,-4.2227 18.66402,-11.793 35.25802,-16.184 l 0.0781,179.05 c -16.609,-5.4375 -33.40202,-14.258 -35.33602,-18.598 z m 76.41802,56.82 c -15.953,0 -28.594,-4.1094 -32.664,-8.6055 l -0.10547,-241.31 c 4.1562,-4.6406 17.141,-8.8945 33.543,-8.8945 16.66,0 28.996,4.2852 32.352,8.8438 v 240.77 c -3.4688,4.7227 -16.488,9.1914 -33.125,9.1914 z m 41.52,-102.3 v -50.574 c 0.3125,0.0352 253.35,0.0352 253.8,-0.043 v 50.652 c -0.46094,-0.082 -253.49,-0.0703 -253.8,-0.0352 z m 294.86,102.3 c -15.949,0 -28.59,-4.1055 -32.664,-8.6055 v -241.98 c 3.9688,-4.3672 16.066,-8.3281 32.109,-8.3281 16.363,0 31.32,6.7188 33.219,8.7656 v 241.54 c -4.0703,4.5 -16.707,8.6055 -32.664,8.6055 z m 41.066,-38.266 v -178.38 c 14.699,4.1289 29.586,11.543 30.863,15.172 l 0.0234,144.75 c -1.0781,4.0977 -15.867,12.883 -30.887,18.457 z m 68.723,-73.777 c -2.3398,2.6445 -12.191,6.5977 -21.062,7.5078 v -47.762 c 8.8633,0.91406 18.723,4.8672 21.062,7.5078 z m -370.88,-18.461 c 0,2.3203 -1.8828,4.1992 -4.1992,4.1992 h -10.852 c -2.3203,0 -4.1992,-1.8828 -4.1992,-4.1992 0,-2.3203 1.8828,-4.1992 4.1992,-4.1992 h 10.852 c 2.3203,0 4.1992,1.875 4.1992,4.1992 z m 37.102,0 c 0,2.3203 -1.8828,4.1992 -4.1992,4.1992 h -17.855 c -2.3203,0 -4.1992,-1.8828 -4.1992,-4.1992 0,-2.3203 1.8828,-4.1992 4.1992,-4.1992 h 17.852 c 2.3203,0 4.2031,1.875 4.2031,4.1992 z m 171.547,0 c 0,2.3203 -1.8828,4.1992 -4.1992,4.1992 h -150.898 c -2.3203,0 -4.1992,-1.8828 -4.1992,-4.1992 0,-2.3203 1.8828,-4.1992 4.1992,-4.1992 h 150.898 c 2.3164,0 4.1992,1.875 4.1992,4.1992 z',
            $this->frameId()
        );
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(-9.35%%, -31.8%%) scale(3.125);
        }

        #%2$s path {
            transform: scale(0.75);
        }
        
        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
