<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

use SVG\Nodes\Shapes\SVGPath;
use SVG\Nodes\Structures\SVGSymbol;

class IceCreamShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'ice-cream';

    protected function symbolPath()
    {
        return 'm 661.50167,231.08222 c -12.72407,-9.08771 -44.12917,-23.4705 -59.22828,-27.12515 -20.52275,-4.9674 -48.2936,-6.43013 -65.30543,-3.43972 -39.01689,6.85855 -33.47926,8.29516 -45.52846,-11.81133 -14.16695,-23.6404 -43.97359,-51.34349 -68.22333,-63.4086 l -19.08158,-9.49376 12.8538,-11.02583 c 61.81229,-53.021841 152.19365,-49.747344 209.90699,7.60488 20.07963,19.954 29.79313,35.26701 38.80052,61.16775 6.61447,19.01991 11.57908,60.36119 7.54154,62.79973 -1.29925,0.78469 -6.58034,-1.5859 -11.73577,-5.26797 z M 310.66475,522.7919 c -8.32799,-2.59687 -13.39072,-9.57721 -13.39072,-18.46278 0,-12.23703 -6.23863,-26.32873 -13.83656,-31.25379 -3.43724,-2.22805 -12.27535,-5.50455 -19.64024,-7.28112 -20.4603,-4.93542 -21.85356,-7.05241 -23.33964,-35.46338 -1.42238,-27.19326 -2.88472,-31.08964 -19.78342,-52.71247 -24.05714,-30.78244 -34.98805,-66.67076 -32.45221,-106.547 7.04076,-110.71673 123.85226,-177.670318 223.98612,-128.38357 21.41324,10.53979 48.53999,35.29683 62.12919,56.70181 l 10.11763,15.93671 -11.23749,6.36752 c -41.49123,23.51026 -71.38201,62.54264 -83.51524,109.05701 -5.22536,20.03212 -5.48794,64.67585 -0.49227,83.69426 l 3.69387,14.06251 -9.65131,2.40733 c -5.30822,1.32402 -12.66422,3.10576 -16.34667,3.95945 -23.24083,5.38767 -34.66447,23.56309 -34.75706,55.29966 -0.0755,25.88296 -7.4034,37.00845 -21.48398,32.61785 z m 254.28115,80.21369 c -5.22174,-4.22834 -6.3404,-8.37354 -7.82895,-29.01046 -2.10605,-29.19788 -7.3252,-38.26091 -26.18018,-45.46169 -19.07345,-7.28424 -31.99489,-6.43358 -39.78151,2.6189 -3.52611,4.09936 -6.41112,10.73352 -6.41112,14.74257 0,16.47519 -15.94992,27.51876 -29.57131,20.47487 -9.67544,-5.00336 -10.2415,-7.57963 -11.18228,-50.89332 -0.74557,-34.32635 -0.89841,-35.10151 -9.59018,-48.64143 -20.85118,-32.48163 -29.89233,-60.64856 -29.96098,-93.34074 -0.12054,-57.4133 34.49717,-112.72957 85.93879,-137.32315 29.25322,-13.98559 46.49531,-17.53487 77.65904,-15.98611 40.06959,1.99136 71.8181,16.06932 100.42227,44.52934 74.71343,74.33687 55.41218,197.57597 -38.87189,248.19844 -28.3078,15.19887 -30.72405,19.32396 -32.39055,55.29827 -1.24681,26.91455 -1.92671,29.98783 -7.66159,34.63165 -7.94601,6.4343 -16.77247,6.49273 -24.58956,0.16283 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 325.69542,406.425 c -0.61291,0.0893 -1.23432,0.0893 -1.84299,0 -24.83131,-8.10404 -48.53924,-19.31567 -70.5528,-33.36957 -1.41738,-0.92788 -2.40904,-2.37929 -2.75379,-4.03922 -0.34477,-1.65568 -0.017,-3.37956 0.91085,-4.79683 1.92808,-2.9496 5.88645,-3.77531 8.83191,-1.84298 20.99695,13.36962 43.5891,24.04788 67.25017,31.782 3.34545,1.00874 5.24379,4.52867 4.25627,7.87848 -0.85978,2.63895 -3.32846,4.41383 -6.09936,4.38823 z m 83.07252,97.6952 c -56.63511,0 -134.24101,-37.11895 -137.48808,-38.70652 -3.1539,-1.51523 -4.48617,-5.29489 -2.98795,-8.45304 0.72783,-1.53223 2.03879,-2.70705 3.63486,-3.26886 1.60043,-0.56183 3.3582,-0.45969 4.88204,0.28091 0.76188,0.38307 78.24442,37.43821 131.95281,37.43821 h 0.69804 c 3.51151,0 6.35466,2.84325 6.35466,6.35465 0,3.51152 -2.84325,6.35466 -6.35466,6.35466 z m -22.63138,70.80342 c -35.59566,-1.01726 -83.26647,-20.91087 -85.30079,-21.73681 h 0.004 c -1.61743,-0.61291 -2.91561,-1.85997 -3.59237,-3.44766 -0.68101,-1.58757 -0.68101,-3.38806 -0.009,-4.97988 0.67675,-1.58758 1.96643,-2.839 3.58386,-3.45616 1.61318,-0.61717 3.40931,-0.54907 4.97563,0.18728 0.44692,0 47.47905,19.76677 80.72113,20.72019 3.51151,0 6.35465,2.8475 6.35465,6.3589 0,3.50727 -2.84325,6.35466 -6.35465,6.35466 z m -37.94052,71.44629 c -5.53319,0.0851 -10.95176,-1.60893 -15.45079,-4.83518 -4.49893,-3.23051 -7.84013,-7.81889 -9.52992,-13.0885 L 245.738,394.73393 c -0.53203,-1.60043 -0.40434,-3.3497 0.34902,-4.85643 0.75762,-1.50672 2.08564,-2.65169 3.68596,-3.18375 3.33271,-1.10662 6.93357,0.70229 8.04019,4.03496 l 77.6691,233.7123 c 1.60893,5.6354 6.86122,9.44056 12.71367,9.2149 5.81835,0.0426 10.97682,-3.72432 12.71367,-9.27875 L 415.5736,458.48272 h -0.004 c 1.10662,-3.3327 4.70748,-5.14169 8.04444,-4.03496 3.3327,1.10661 5.14169,4.70323 4.03496,8.04018 l -54.66398,165.89444 c -1.67704,5.24803 -4.98839,9.81931 -9.44482,13.05363 -4.46068,3.23911 -9.83631,4.96288 -15.34401,4.93303 z M 236.07429,406.425 c -7.20598,0.0511 -14.13127,-2.7709 -19.24703,-7.84014 -5.12033,-5.07348 -8.00619,-11.97273 -8.02319,-19.1751 v -4.06908 c -0.004,-5.07348 -3.42205,-9.50866 -8.32534,-10.80258 l -16.59162,-4.19678 c -5.08209,-1.37902 -9.56816,-4.39247 -12.7736,-8.57225 -3.205,-4.17966 -4.94588,-9.29575 -4.95863,-14.56493 v -23.70792 c -0.0127,-5.44809 -2.08139,-10.68763 -5.78435,-14.68043 -26.14213,-28.68748 -38.17043,-67.5095 -32.83348,-105.95233 5.33739,-38.43848 27.49544,-72.51521 60.46512,-92.992415 32.96968,-20.472843 73.33678,-25.226849 110.16044,-12.972999 36.82148,12.25821 66.28803,40.255964 80.41058,76.405144 1.26418,3.28161 -0.3703,6.96757 -3.65197,8.23174 -3.28585,1.25982 -6.96756,-0.37455 -8.23174,-3.65621 -12.82045,-32.56979 -39.44746,-57.75415 -72.67211,-68.752756 -33.22901,-10.994251 -69.62445,-6.656916 -99.33835,11.836526 -29.7139,18.48974 -49.68007,49.22897 -54.48965,83.89627 -4.80968,34.66731 6.03126,69.68002 29.58533,95.56282 5.8482,6.33766 9.09581,14.6423 9.09156,23.26554 v 23.38866 c 0.0724,4.99689 3.48591,9.31712 8.32534,10.55144 l 16.71475,4.44782 v 0.004 c 5.07348,1.40462 9.53841,4.43507 12.72238,8.6276 3.17951,4.18827 4.89479,9.30861 4.88629,14.56929 v 4.13292 c 0,7.93373 6.43126,14.36553 14.36553,14.36553 7.93428,0 14.36553,-6.43125 14.36553,-14.36553 v -20.46848 c -0.10645,-7.61459 2.49425,-15.01604 7.33368,-20.89453 4.84368,-5.87795 11.61098,-9.84917 19.10646,-11.20237 8.45305,-1.47698 16.72347,-3.86477 24.66134,-7.11652 3.24761,-1.33652 6.96332,0.21708 8.29559,3.46041 1.33228,3.24761 -0.21707,6.96332 -3.46466,8.2956 -8.7893,3.63486 -17.95691,6.27805 -27.32981,7.88273 -4.51592,0.90234 -8.57225,3.35396 -11.47041,6.92507 -2.90286,3.57526 -4.46493,8.04869 -4.41808,12.64939 v 20.46848 c -0.017,7.13788 -2.85175,13.97763 -7.88699,19.03891 -5.03523,5.05648 -11.86268,7.92523 -19.00077,7.97633 z m 196.65436,63.43759 c -7.44852,0 -14.59544,-2.9581 -19.86375,-8.22749 -5.26928,-5.26929 -8.22749,-12.41621 -8.22749,-19.86375 v -16.97408 c -0.0213,-3.91151 -1.37902,-7.69968 -3.85627,-10.73023 -2.47714,-3.03045 -5.9163,-5.12034 -9.74696,-5.92056 -2.6687,-0.57035 -5.27354,-1.27267 -7.81889,-2.03453 -1.37902,-0.37882 -2.856,-0.0936 -4.00097,0.76188 -1.24282,0.90234 -1.97918,2.34519 -1.97068,3.87752 0.37029,7.91248 -2.5155,15.63385 -7.98484,21.36633 -5.46934,5.73325 -13.046,8.9766 -20.96644,8.9766 -7.92523,0 -15.502,-3.24335 -20.9708,-8.9766 -5.46934,-5.73325 -8.35519,-13.45461 -7.98483,-21.36633 v -39.59674 c 0.0554,-4.25202 -1.28118,-8.40619 -3.81367,-11.82454 -17.05035,-22.66952 -26.28705,-50.25866 -26.31211,-78.62252 -0.0511,-25.91222 7.63158,-51.25021 22.06914,-72.76582 14.4418,-21.51561 34.97458,-38.23036 58.97125,-48.00315 15.71448,-6.52921 32.56543,-9.87467 49.57764,-9.84917 40.46517,0.0384 78.62688,18.83406 103.32636,50.8841 24.70383,32.0544 33.15273,73.74539 22.88199,112.88449 -10.27053,39.13692 -38.10288,71.31008 -75.35803,87.10193 -3.01769,1.32367 -5.58004,3.50726 -7.36767,6.27805 -1.78338,2.76665 -2.71555,6.0014 -2.67719,9.29576 v 25.42298 c -0.0639,7.38042 -3.0262,14.4418 -8.24449,19.65999 -5.2183,5.21829 -12.28,8.18063 -19.65999,8.24449 z m -50.85032,-76.65685 0.004,0.004 c 1.63443,0.009 3.26036,0.24262 4.83093,0.69803 2.3538,0.69803 4.70323,1.27268 7.12088,1.84298 h -0.004 c 6.65266,1.42163 12.61124,5.08209 16.89345,10.36838 4.27762,5.28639 6.61431,11.87902 6.62706,18.67715 v 16.97408 c 0,4.07757 1.61743,7.98908 4.50317,10.87494 2.88575,2.88574 6.79737,4.50317 10.87494,4.50317 8.5084,0 15.41265,-6.87396 15.44643,-15.37778 v -25.42734 c -0.0297,-5.7886 1.64293,-11.45843 4.80544,-16.30615 3.1624,-4.84793 7.68268,-8.65734 12.99479,-10.96047 33.41642,-14.42437 58.30767,-43.47033 67.44194,-78.70751 9.13406,-35.23391 1.48973,-72.71461 -20.71147,-101.55572 -22.20098,-28.84547 -56.47711,-45.82827 -92.87691,-46.01459 -15.27209,0.0127 -30.39055,3.0348 -44.4913,8.9 -21.71174,8.7808 -40.29846,23.85284 -53.37824,43.2742 -13.08414,19.42572 -20.05988,42.31643 -20.03482,65.73451 0.017,25.58425 8.33809,50.4755 23.70792,70.932 4.17117,5.64814 6.40151,12.49247 6.35466,19.51506 v 39.59674 c -0.28091,4.48193 1.30667,8.8829 4.37972,12.15579 3.0773,3.27735 7.36768,5.13308 11.86268,5.13308 4.49043,0 8.7808,-1.85573 11.85832,-5.13308 3.0773,-3.27311 4.66062,-7.67418 4.37972,-12.15579 -0.017,-4.62238 1.80038,-9.06595 5.05224,-12.35627 3.25185,-3.28585 7.67418,-5.15444 12.3007,-5.18419 z M 509.7102,201.44595 h -1.46422 c -1.64718,-0.39159 -3.06881,-1.42588 -3.94987,-2.86875 -0.88106,-1.44288 -1.15347,-3.17951 -0.75338,-4.82244 2.05579,-8.75094 3.08156,-17.71066 3.05181,-26.69565 0.0894,-33.05467 -13.70958,-64.62419 -38.02551,-87.011496 -24.32029,-22.388393 -56.9195,-33.530833 -89.85104,-30.717438 -32.9359,2.817645 -63.17282,19.332013 -83.33403,45.520997 -2.16224,2.8475 -6.21421,3.400808 -9.05746,1.242818 -2.8475,-2.162239 -3.4008,-6.214203 -1.24281,-9.057454 22.29032,-29.117878 55.79609,-47.521536 92.32774,-50.705402 36.53164,-3.188006 72.71461,9.138305 99.70882,33.956874 26.99312,24.818243 42.30335,59.848391 42.18894,96.516241 0.0255,9.99387 -1.12797,19.95745 -3.43481,29.68339 -0.65122,2.88574 -3.205,4.94163 -6.1631,4.95863 z',
            $this->frameId()
        );
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(16%%, -4%%) scale(1.3);
        }

        #%2$s path {
            transform: scale(0.75);
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
