<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class LocksmithShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'locksmith';

    protected function symbolPath()
    {
        return 'm 475.37064,274.93821 c 0,-56.09816 0.73586,-68.06333 5.27817,-85.8236 16.42167,-64.20812 61.0669,-112.416697 124.63754,-134.585438 19.32562,-6.739349 24.90323,-7.462547 57.5544,-7.462547 32.60686,0 38.25752,0.730319 57.5801,7.441937 64.97915,22.570229 115.1029,79.738378 126.98853,144.835528 1.59583,8.74016 2.90148,43.99123 2.90148,78.33572 v 62.44453 h -38.8331 -38.83309 v -62.65429 c 0,-54.9744 -0.65114,-64.74059 -5.3121,-79.6748 -13.87649,-44.46175 -56.48581,-74.60061 -105.46787,-74.60061 -43.29882,0 -81.99546,24.64231 -100.4081,63.9406 -6.96708,14.86992 -7.06925,15.95614 -7.90364,84.02688 l -0.84531,68.96222 h -38.66851 -38.6685 z M 121.22365,886.47729 C 107.78323,882.43032 96.27499,873.45466 89.615828,861.8253 L 83.022477,850.31086 V 625.34672 400.38259 l 7.102286,-12.08043 c 4.375197,-7.44187 11.573547,-14.64022 18.747007,-18.74701 l 11.64473,-6.66658 237.85956,-0.72585 c 161.78574,-0.4937 241.24122,0.18475 248.43306,2.12131 12.94513,3.48576 28.79894,16.95652 33.66633,28.6058 5.34486,12.79205 5.34486,452.12173 0,464.91378 -4.78265,11.44649 -20.54517,25.00548 -33.13301,28.50116 -12.21231,3.39139 -474.88324,3.55558 -486.11879,0.17247 z';
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 494.287,18.0713 c -6.59534,0.08576 -13.184,0.587682 -19.71703,1.495628 -2.64429,0.377328 -5.55188,0.853054 -8.27755,1.390704 -21.85859,4.240934 -42.98307,13.415256 -61.14378,26.490432 -24.43888,17.510522 -43.72749,42.130915 -54.75967,70.108376 -2.70231,6.84565 -4.92931,13.87922 -6.63946,21.03777 -0.60996,2.58781 -1.23506,5.4588 -1.72171,8.18393 -0.83416,4.57174 -1.46413,9.20812 -1.87542,13.70163 -0.26285,2.80339 -0.43099,5.5677 -0.52904,8.29387 -0.23224,6.08986 -0.0979,12.41177 -0.12979,18.59254 -1e-5,22.86261 0,45.72522 0,68.58783 -80.36069,10e-4 -160.72175,-0.0156 -241.082188,0.0243 -3.32662,0.0477 -6.89737,0.52981 -9.98193,1.21084 -1.26325,0.28764 -2.34619,0.57038 -3.65845,0.95802 -1.88586,0.57137 -3.64416,1.20627 -5.37745,1.93195 -13.87274,5.75861 -25.08815,17.54447 -30.11314,31.70348 -1.75449,4.87383 -2.8074,10.00492 -3.05344,15.18115 -0.046,0.88123 -0.0639,2.1887 -0.0591,3.24097 0.004,106.44513 -0.0124,212.89058 0.0207,319.3355 0.0825,4.69363 0.85399,9.36653 2.19717,13.86194 0.2142,0.67438 0.56566,1.79623 0.87207,2.63149 5.021,14.16302 16.21375,25.97595 30.09151,31.74158 7.06635,3.00587 14.78469,4.37503 22.453158,4.13999 115.17707,-0.008 230.35439,0.0124 345.53131,-0.0124 15.57164,-0.23003 30.71924,-7.89492 40.46501,-19.98465 4.27693,-5.21179 7.60507,-11.47934 9.59217,-17.75563 1.91545,-5.89023 2.63327,-12.11303 2.45435,-18.29124 0.003,-105.79981 0.0198,-211.5999 -0.0124,-317.39954 -0.22999,-15.5696 -7.89092,-30.71969 -19.9805,-40.46412 -2.38448,-1.95101 -4.94899,-3.67748 -7.62974,-5.19533 -0.65033,-0.35998 -1.69187,-0.92639 -2.52179,-1.32817 -4.52472,-2.24165 -9.36472,-3.8465 -14.33558,-4.73758 -1.08677,-0.18941 -2.5634,-0.40672 -3.81291,-0.53166 -1.8913,-0.18377 -3.4926,-0.25971 -5.40628,-0.25781 -5.70826,-8e-4 -11.41654,-0.003 -17.12481,-0.003 0.0172,-27.84832 -0.0472,-55.69769 0.0445,-83.54534 0.55134,-17.09966 8.08961,-33.78715 20.3689,-45.67129 11.96841,-11.71998 28.41811,-18.79534 45.19069,-19.13764 15.80635,-0.43296 31.66112,5.03451 43.89744,15.03935 13.2342,10.71507 22.27147,26.54662 24.44445,43.46455 0.95439,7.50369 0.43371,15.08372 0.56914,22.6239 0,27.09978 0,54.19955 0,81.29933 30.09694,10e-4 60.19388,0.004 90.29081,0.005 -0.0151,-32.83489 0.0437,-65.67053 -0.0428,-98.50494 -0.13529,-6.75966 -0.70483,-13.50999 -1.69971,-20.19743 -1.17536,-7.83847 -3.0072,-15.85721 -5.41695,-23.52049 -0.94193,-2.97806 -1.93061,-5.84015 -2.99265,-8.64216 C 638.94899,106.69611 632.4728,94.636809 624.63906,83.728589 613.68675,68.389731 599.71235,54.923201 583.93568,44.425913 581.76715,42.996807 579.62765,41.634571 577.47063,40.356041 563.44441,31.965769 548.09831,25.797971 532.17406,22.120382 519.87633,19.285345 506.99022,17.913427 494.2866,18.071177 Z m 2.7657,14.835448 c 26.81753,-0.06037 53.61356,7.668456 76.21197,22.124598 23.40015,14.861746 42.28104,36.728313 53.52094,62.072544 8.47097,18.98706 12.57693,39.8566 12.19865,60.63173 -8.4e-4,25.81592 -10e-4,51.63184 -0.003,77.44775 -19.94349,0 -39.88699,0 -59.83048,0 -0.0183,-27.67756 0.0499,-55.35608 -0.048,-83.03304 -0.0792,-3.08228 -0.36784,-6.17344 -0.78632,-9.12024 -2.40748,-16.90519 -10.24588,-32.98667 -22.14711,-45.24049 -15.8886,-16.63653 -38.95025,-25.921201 -61.9821,-24.998661 -2.06955,0.0646 -4.62975,0.26306 -6.78,0.51018 -17.69454,2.00049 -34.6345,10.006121 -47.39586,22.428121 -10.9388,10.49737 -18.85027,24.09642 -22.54689,38.80133 -0.28877,1.21099 -0.67323,2.79787 -0.93147,4.16811 -0.66817,3.30307 -1.12667,6.88503 -1.36433,10.09271 -0.11494,1.69628 -0.18398,3.20332 -0.20512,4.96194 -0.0243,27.14316 -0.006,54.28673 -0.0151,81.43004 -19.94349,0 -39.88699,0 -59.83048,0 0.0173,-27.95436 -0.0482,-55.90947 0.0468,-83.86337 0.57796,-26.65633 8.89868,-53.09277 23.74294,-75.246281 16.10021,-24.202521 39.81199,-43.260128 66.95544,-53.684899 16.28211,-6.284475 33.73897,-9.495651 51.18906,-9.482072 z M 447.08478,270.81095 c 12.08381,0.15097 23.90979,6.3875 30.82367,16.30749 5.01779,7.03551 7.4395,15.77834 7.09601,24.38915 -10e-4,106.03035 0.0137,212.0611 -0.02,318.09118 -0.29438,11.92628 -6.5013,23.53542 -16.28798,30.36852 -7.00081,4.98583 -15.68267,7.42917 -24.25183,7.10181 -115.32472,-0.005 -230.64984,0.0137 -345.974308,-0.0221 -11.97013,-0.2966 -23.61567,-6.55823 -30.43617,-16.40713 -4.96054,-7.01946 -7.35715,-15.7124 -7.01485,-24.2782 10e-4,-106.02944 -0.0138,-212.0593 0.02,-318.08848 0.29349,-11.95238 6.52613,-23.58363 16.34775,-30.41332 6.94743,-4.93038 15.54228,-7.35534 24.036928,-7.05973 115.22026,-0.005 230.44054,-10e-4 345.66082,0.011 z',
            $this->frameId()
        );
    }

    protected function renderStyles()
    {
        return sprintf(
            '.foreground-0 {
            transform: translate(-18.5%%, 9%%) scale(3);
        }

        #%2$s path {
            transform: scale(0.75);
        }
        
        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }',
            $this->maskId(),
            $this->symbolId(),
            $this->frameId(),
            $this->qrcode->design->frameColor
        );
    }

    protected function frameStrokeWidth()
    {
        return 7;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
