<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class RestaurantShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'restaurant';

    protected function symbolPath()
    {
        return 'm 46.867527,827.54663 c -2.945958,-2.94596 -5.356288,-7.16404 -5.356288,-9.37351 0,-2.20947 2.41033,-6.42754 5.356288,-9.3735 5.310168,-5.31017 8.927148,-5.35629 420.053593,-5.35629 398.35079,0 414.87202,0.19305 419.1296,4.89763 5.81479,6.42525 5.62539,14.61763 -0.46533,20.12966 -4.51286,4.08408 -37.44067,4.4323 -419.1296,4.4323 -410.661115,0 -414.278147,-0.0462 -419.588263,-5.35629 z m 25.026441,-71.64037 c 3.676545,-49.93911 23.114754,-112.22306 49.104582,-157.34098 18.64413,-32.36591 34.49018,-53.46211 60.93418,-81.12301 50.74201,-53.07706 112.94996,-89.9675 183.5895,-108.87189 13.54488,-3.62485 26.32696,-8.00143 28.40464,-9.72574 2.07768,-1.72431 3.77758,-7.62142 3.77758,-13.10469 0,-14.88196 5.97322,-18.83416 28.4653,-18.83416 10.95029,0 19.99888,-1.32885 21.88381,-3.21378 4.57599,-4.57598 3.97683,-27.84549 -0.98628,-38.30447 -2.42792,-5.11652 -10.31538,-12.91129 -18.69401,-18.4744 -19.49153,-12.94165 -21.54141,-20.76154 -8.56071,-32.65746 11.67954,-10.70352 24.35828,-14.44126 49.05203,-14.46073 15.36639,-0.0121 21.67749,1.3735 33.47681,7.34996 15.81482,8.01035 22.5537,17.30621 18.30329,25.24817 -1.42222,2.65747 -9.14133,9.67456 -17.15354,15.59353 -17.24002,12.73594 -20.04993,17.32509 -21.9641,35.87174 -2.01643,19.53731 1.96967,23.04744 26.17262,23.04744 22.73881,0 29.26829,4.79255 29.26829,21.48257 0,12.35175 -0.58692,11.98861 34.81588,21.54173 106.87515,28.8393 200.1493,106.19009 250.07366,207.3822 22.43101,45.46557 35.58373,91.99515 40.691,143.95026 l 1.77706,18.07748 H 467.24715 70.168762 Z M 788.99144,700.79431 c 2.2501,-4.93844 1.36489,-10.63379 -4.25466,-27.37417 C 749.15755,567.43148 654.89437,483.16997 546.80859,460.73701 c -13.98774,-2.90312 -16.14804,-2.74372 -20.88238,1.54081 -6.03105,5.458 -5.84529,16.76514 0.32917,20.0387 2.20947,1.17141 15.46628,5.24486 29.45959,9.05211 60.83807,16.55263 114.25427,51.6492 153.79935,101.05232 19.22281,24.01478 40.52874,62.87292 49.45703,90.2006 6.87501,21.04303 9.552,24.40858 19.41494,24.40858 5.53002,0 8.58144,-1.79422 10.60515,-6.23582 z';
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 591.66474,518.69674 c -24.26297,-88.99228 -98.54567,-157.15422 -189.2227,-173.65375 -4.9311,-0.96092 -9.6408,2.36432 -10.53851,7.2954 -0.89773,4.91848 2.37709,9.63447 7.2954,10.53219 83.85874,15.2736 152.54665,78.29632 174.98083,160.58844 1.10634,4.03339 4.74773,6.6822 8.73675,6.6822 0.79026,0 1.58683,-0.10113 2.38971,-0.31609 4.82363,-1.32127 7.66845,-6.30914 6.3535,-11.13276 z M 385.88938,85.494866 c 4.70219,-4.215478 11.13877,-9.985691 11.13877,-20.973353 0,-3.747644 -3.03397,-6.776901 -6.7769,-6.776901 -3.73809,0 -6.7769,3.029257 -6.7769,6.776901 0,4.730619 -2.15492,6.871387 -6.63039,10.878899 -4.69275,4.206043 -11.12933,9.980972 -11.12933,20.963674 0,10.987534 6.43658,16.761984 11.13877,20.973354 4.48006,4.01223 6.62566,6.14356 6.62566,10.86474 0,4.70691 -2.14548,6.8478 -6.62566,10.85531 -4.69275,4.20604 -11.13877,9.96682 -11.13877,20.94069 0,3.74764 3.03397,6.7769 6.7769,6.7769 3.73808,0 6.7769,-3.02926 6.7769,-6.7769 0,-4.70691 2.14548,-6.84296 6.62567,-10.84575 4.70219,-4.20605 11.13876,-9.97154 11.13876,-20.94916 0,-10.98282 -6.43657,-16.75352 -11.12933,-20.96367 -4.48006,-4.01695 -6.63039,-6.153 -6.63039,-10.878902 -0.0121,-4.721061 2.13606,-6.857231 6.61624,-10.864743 z m -48.62246,0 c 4.70218,-4.215478 11.13876,-9.985691 11.13876,-20.973353 0,-3.747644 -3.03397,-6.776901 -6.7769,-6.776901 -3.73809,0 -6.7769,3.029257 -6.7769,6.776901 0,4.730619 -2.15492,6.871387 -6.63039,10.878899 -4.70218,4.206043 -11.13876,9.980972 -11.13876,20.963674 0,10.987534 6.43658,16.761984 11.13876,20.973354 4.48006,4.01223 6.62567,6.14356 6.62567,10.86474 0,4.70691 -2.14548,6.8478 -6.62567,10.85531 -4.70218,4.20604 -11.13876,9.96682 -11.13876,20.94069 0,3.74764 3.03397,6.7769 6.7769,6.7769 3.73809,0 6.7769,-3.02926 6.7769,-6.7769 0,-4.70219 2.14548,-6.84296 6.62566,-10.84575 4.7022,-4.20605 11.14349,-9.97154 11.14349,-20.94916 0,-10.98282 -6.43658,-16.75352 -11.13876,-20.96367 -4.48007,-4.01695 -6.63039,-6.153 -6.63039,-10.878902 0,-4.721061 2.15491,-6.857231 6.63039,-10.864743 z M 42.919168,642.24389 H 657.05141 c 15.88682,0 28.82199,-12.93453 28.82199,-28.82198 0,-12.98503 -8.71149,-23.97814 -20.60216,-27.51271 C 663.4253,515.44591 637.86534,447.15774 592.8853,392.91563 548.45551,339.34351 487.1847,301.72232 419.74943,286.46247 c -0.006,-15.9627 -12.93453,-28.92879 -28.80903,-28.92879 h -12.18216 c 0.0822,-4.7856 2.53506,-8.59773 6.9604,-10.74712 15.11547,-7.40286 23.78877,-18.83973 23.78877,-31.37582 0,-21.90496 -26.1225,-39.06318 -59.4501,-39.06318 -33.39882,0 -59.55206,17.15822 -59.55206,39.06318 0,12.5173 8.6673,23.95387 23.78877,31.38876 4.40641,2.14939 6.87186,5.95522 6.95408,10.7408 h -12.18844 c -15.88051,0 -28.80258,12.97872 -28.80906,28.9288 -67.43527,15.26099 -128.71255,52.8762 -173.13587,106.45316 -44.973573,54.24211 -70.539348,122.5238 -72.385937,192.99358 -11.897793,3.52761 -20.60217,14.53399 -20.60217,27.5127 -0.01887,15.89944 12.90298,28.82685 28.783157,28.82685 z M 290.20988,301.32904 c 3.86893,-0.79022 6.66326,-4.19779 6.66326,-8.14893 v -6.70744 c 0,-6.79596 5.46209,-12.31501 12.18214,-12.31501 h 20.5083 c 4.59592,0 8.31321,-3.72362 8.31321,-8.3132 v -8.07305 c 0,-11.2718 -6.08792,-20.96307 -16.27943,-25.92022 -9.06561,-4.45057 -14.46441,-10.59546 -14.46441,-16.44288 0,-10.60178 17.62594,-22.42931 42.92468,-22.42931 25.23079,0 42.82435,11.81556 42.82435,22.42931 0,5.85406 -5.41791,11.99895 -14.46442,16.42994 -10.19717,4.96896 -16.28427,14.6667 -16.28427,25.93154 v 8.07303 c 0,4.59592 3.72359,8.31322 8.31952,8.31322 h 20.48887 c 6.70745,0 12.18215,5.51905 12.18215,12.31502 v 6.70743 c 0,3.95746 2.78169,7.35867 6.65063,8.14895 135.23631,27.48033 234.48921,145.90799 238.84269,283.39709 H 51.413316 C 55.743812,447.23057 154.98411,328.80777 290.20745,301.32744 Z M 42.757319,601.36324 h 0.15165 0.265506 613.662915 0.22758 0.18334 c 6.63169,0.0885 12.01156,5.47471 12.01156,12.07469 0,6.71375 -5.47471,12.18845 -12.18845,12.18845 H 42.939167 c -6.713749,0 -12.182136,-5.4747 -12.182136,-12.18845 0,-6.6126 5.367248,-11.98616 12.005236,-12.07469 z',
            $this->frameId()
        );
    }

    protected function renderStyles()
    {
        return sprintf(
            '.foreground-0 {
            transform: translate(-8.5%%, 18%%) scale(1.84);
        }

        #%2$s path {
            transform: scale(0.75);
        }
        
        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }',
            $this->maskId(),
            $this->symbolId(),
            $this->frameId(),
            $this->qrcode->design->frameColor
        );
    }

    protected function frameStrokeWidth()
    {
        return 7;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
