<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class TravelShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'travel';

    protected function symbolPath()
    {
        return 'm 338.69433,509.77549 -0.70036,0.70036 c -18.25402,11.23514 -37.21267,21.76465 -56.87094,30.1889 -19.65953,8.42401 -40.02368,14.74715 -60.38282,18.95865 -20.35914,4.212 -42.13006,5.61764 -62.4892,3.51163 -20.35915,-2.10599 -40.7233,-7.02326 -58.977313,-16.14763 -17.55315,-9.12914 -33.700788,-22.47053 -43.530551,-40.02368 -9.829516,-16.85228 -15.446774,-37.21267 -14.041261,-57.57683 1.405626,-20.35914 7.723634,-41.42417 17.55314,-60.38282 9.829516,-18.95865 23.17016,-37.21267 37.912296,-53.36031 2.806366,-2.80637 2.806366,-7.72364 0,-10.52988 -2.806377,-2.80638 -7.723644,-2.80638 -10.529887,0 -16.852276,16.14763 -32.300294,34.40541 -44.235179,54.76581 -12.63576,20.35915 -21.76465,43.53055 -24.576914,68.10621 -3.511633,24.57691 1.40563,51.25393 13.341644,73.72447 11.935517,23.17015 30.894786,41.42417 52.659434,54.76581 21.764651,13.34164 46.341561,21.06503 70.212591,25.27653 24.57691,3.51163 49.14755,3.51163 73.72447,0.70036 24.5769,-2.80637 47.74205,-9.12914 70.91345,-16.85228 23.17015,-7.72363 44.93605,-18.25401 66.00108,-29.48928 0.70036,0 0.70036,-0.70036 1.40563,-0.70036 11.93551,-7.72363 16.14765,-23.17015 8.42401,-35.10629 -7.72364,-14.03625 -23.17016,-18.25402 -35.81093,-10.52988 z M 666.5871,272.45696 c -24.57692,0.70036 -47.74205,9.82951 -66.00108,25.9774 l -57.57182,50.55306 -85.65935,-42.13006 c -11.93551,-5.61763 -25.9774,-5.61763 -37.21267,0 -4.91726,2.10601 -5.61763,8.42401 -1.40563,11.93552 l 75.82959,73.72446 -75.82959,66.70071 -30.1889,-16.85228 c -8.42402,-4.91727 -18.95865,-3.51163 -26.68204,2.10601 l -4.91727,3.51163 c -3.51163,2.80636 -3.51163,8.424 0,10.52987 l 41.42418,32.3003 c 6.318,4.91727 11.23514,11.23514 14.74715,18.25402 l 23.17015,47.04243 c 2.106,4.212 7.02326,4.91726 10.52988,2.106 l 4.91726,-3.51163 c 7.72364,-6.318 10.52988,-16.14764 7.72364,-25.27653 l -9.12914,-32.98989 80.74197,-60.38281 56.17131,89.8721 c 2.80638,4.21201 9.12914,4.91726 11.93552,0.70036 7.72363,-10.52988 10.52987,-23.87102 7.72363,-36.5118 l -23.86601,-91.97723 61.08369,-45.63567 c 19.65953,-14.74715 32.99992,-35.80716 38.61818,-58.97731 2.80637,-11.23515 -5.61763,-21.06503 -16.15265,-21.06503 z M 173.69476,445.88204 h 152.3613 c 1.40564,-8.424 6.31801,-15.44676 12.63576,-21.06503 l 4.91727,-3.51163 c 9.12913,-7.72363 21.06502,-11.93551 33.70078,-11.93551 9.12914,0 17.55314,2.106 25.9774,6.31801 l 11.93552,7.02326 35.80716,-32.30029 -53.36031,-51.25394 c -8.42401,-8.42401 -12.63576,-20.35915 -10.52988,-32.3003 2.106,-11.93551 9.82951,-21.76464 20.35914,-27.38291 9.82951,-4.91726 20.35914,-7.02326 30.89479,-7.02326 11.23514,0 21.76465,2.80637 32.30029,7.72363 l 68.10622,33.70079 26.68202,-23.87103 v -87.06109 c 0,-20.35914 -16.85227,-36.5118 -36.51179,-36.5118 H 422.24605 v -28.08252 c 0,-23.87104 -19.65953,-42.829685 -42.82968,-42.829685 h -55.46543 c -23.87103,0 -42.82968,19.659525 -42.82968,42.829685 v 27.3829 H 173.696 c -20.35913,0 -36.51179,16.85228 -36.51179,36.5118 v 206.425 c -0.70036,21.06001 16.14764,37.21267 36.51179,37.21267 z M 316.92842,138.35093 c 0,-3.51164 2.80638,-6.31801 6.31801,-6.31801 h 55.46544 c 3.51163,0 6.318,2.80637 6.318,6.31801 v 27.3829 h -68.10621 z';
    }


    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf(
            '.foreground-0 {
            transform: translate(-12%%, -6.5%%) scale(1.9);
        }

        #%2$s path {
            transform: scale(1);
        }
        
        #%3$s {
            fill: none;
        }

        .foreground-1 {
            mask: url(#%1$s);
        }',
            $this->maskId(),
            $this->symbolId(),
            $this->frameId(),
            $this->qrcode->design->frameColor
        );
    }

    protected function frameStrokeWidth()
    {
        return 10;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
