<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class WaterGlassShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'water-glass';

    protected function symbolPath()
    {
        return 'm 623.33812,865.43863 c -2.57772,-0.28187 -14.28559,-2.05216 -26.01749,-3.93399 -16.76148,-2.68858 -24.87794,-3.32171 -37.89022,-2.95566 l -16.55947,0.46585 0.87566,-5.18135 c 0.50706,-3.0003 0.35513,-4.97315 -0.36094,-4.68675 -0.68013,0.27202 -5.14513,2.54829 -9.92224,5.05838 -10.6163,5.57823 -15.21659,5.15356 -16.98438,-1.56789 l -1.14014,-4.33497 -11.9497,0.16047 c -7.81587,0.10496 -14.49748,1.03143 -19.31459,2.67815 -7.22439,2.46963 -7.36198,2.61347 -7.21217,7.53919 0.17292,5.68455 -0.97408,6.11303 -8.23869,3.07768 -2.59089,-1.08254 -5.20148,-3.38838 -5.89177,-5.20399 -1.17485,-3.0901 -1.99509,-3.30797 -15.72558,-4.17711 -7.96734,-0.50433 -25.03127,-0.24052 -37.91984,0.58625 -48.97676,3.14172 -68.16246,3.7048 -87.03969,2.55453 -10.6791,-0.65072 -21.18171,-1.55743 -23.33913,-2.01491 l -3.92258,-0.83179 3.25304,-1.80583 c 10.188,-5.65558 34.03479,-14.53523 46.47541,-17.30571 26.41631,-5.88282 37.00442,-6.36909 118.13584,-5.42554 61.51721,0.71543 80.91329,0.49611 103.7781,-1.17348 28.5103,-2.08184 74.53667,-2.78453 82.18555,-1.25476 l 4.1846,0.83692 v 19.9187 19.9187 l -12.38641,-0.2143 c -6.81253,-0.11786 -14.49546,-0.44492 -17.07317,-0.72679 z m 22.76422,-63.61812 c -4.78718,-0.66793 -45.4615,-1.38317 -90.38737,-1.58941 -44.92587,-0.20624 -84.39503,-0.82905 -87.70923,-1.38403 -3.46466,-0.58018 -8.17974,-2.70616 -11.09349,-5.00194 l -5.06768,-3.9929 -8.32304,2.03087 c -13.06737,3.18851 -19.91179,3.81469 -26.18095,2.39522 -4.46439,-1.01083 -6.90205,-0.8568 -10.54778,0.66648 -6.96813,2.91148 -21.97174,-0.0427 -38.89294,-7.65782 l -8.37943,-3.77105 -5.97956,5.17527 c -3.28876,2.8464 -7.26611,5.58361 -8.83856,6.08268 -4.30372,1.36595 -17.35061,-0.61911 -18.17413,-2.76516 -0.45441,-1.18419 -2.46821,-1.74692 -5.60807,-1.56711 l -4.89907,0.28053 -3.0369,-12.05165 c -2.96684,-11.77362 -3.97698,-22.50727 -6.93105,-73.64897 -1.8001,-31.16376 -6.62108,-49.35718 -17.6214,-66.49972 -3.87949,-6.04564 -3.94495,-6.40751 -2.00094,-11.0602 2.10103,-5.02847 7.13813,-8.03814 10.9834,-6.56256 1.85297,0.71104 2.04971,0.0663 1.33951,-4.38956 C 293.21284,581.74573 283.60562,488.57991 273.15271,368.24486 262.16529,241.75651 256.00277,182.4426 246.9972,116.49928 c -2.16245,-15.83453 -3.9371,-29.241987 -3.94366,-29.794354 -0.007,-0.552367 10.68391,-1.006232 23.7566,-1.008589 27.65419,-0.005 97.40199,-1.844903 179.10091,-4.724609 77.78267,-2.741667 183.29031,-4.302323 228.98135,-3.387064 l 37.49402,0.751061 -0.35812,6.025824 c -0.19697,3.314204 -3.64419,46.097561 -7.66051,95.074131 -25.7712,314.26415 -47.92166,602.6292 -47.28985,615.64126 0.24529,5.05176 -0.12453,8.28991 -0.93256,8.16501 -0.73648,-0.11383 -5.25585,-0.7535 -10.04304,-1.42144 z m -15.49498,-200.0032 c 1.15735,-1.15733 2.10426,-2.33356 2.10426,-2.61383 0,-0.28025 1.22075,-9.12531 2.71277,-19.65566 2.06986,-14.60845 3.63303,-21.03241 6.59563,-27.10516 3.684,-7.55149 3.77699,-8.16372 1.8158,-11.95624 -3.96126,-7.66023 0.52147,-23.33097 8.8231,-30.84384 1.54931,-1.40211 2.81693,-3.26458 2.81693,-4.1388 0,-0.87424 -4.21808,-3.24443 -9.37351,-5.26708 -5.15542,-2.02267 -9.3735,-4.13101 -9.3735,-4.68523 0,-0.55421 3.34753,-1.75679 7.43895,-2.67241 4.50924,-1.00913 7.23757,-2.27964 6.92762,-3.226 -0.28125,-0.85868 -3.08242,-3.29594 -6.22487,-5.41613 l -5.71351,-3.8549 7.15511,-2.84046 c 5.99386,-2.37947 7.64409,-3.81016 10.16801,-8.81526 5.19811,-10.30815 3.59675,-35.8999 -3.58519,-57.29637 l -2.35974,-7.03013 h 4.20964 4.20964 l 1.58766,-27.11621 c 0.87322,-14.91392 3.52144,-45.79627 5.88494,-68.62745 3.81668,-36.86865 4.30572,-46.15383 4.37268,-83.02248 0.0637,-35.11664 -0.29685,-43.2646 -2.34113,-52.89335 -1.39861,-6.5876 -3.33961,-12.08719 -4.60792,-13.05596 -3.06669,-2.34241 -11.79021,-2.0851 -17.25692,0.50902 -5.13699,2.43766 -10.15195,10.05661 -12.51297,19.0103 -3.1449,11.92636 -3.86442,34.02383 -2.23125,68.52468 2.33922,49.41618 1.54911,63.93226 -9.25652,170.06217 -3.26189,32.0373 -6.83887,70 -7.94885,84.36155 -2.03632,26.34702 -2.74137,84.07147 -1.16714,95.55677 l 0.85156,6.21272 h 7.08724 c 4.6575,0 7.80864,-0.7214 9.19148,-2.10426 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 212.08398,25.392578 c -6.53049,3.153003 -13.86876,4.352145 -21.08157,4.115503 -7.23194,-0.126791 -14.46015,-0.995079 -21.69572,-0.456131 -3.07242,0.219474 -6.15904,0.551648 -9.16021,1.239066 -1.98536,1.463589 -2.65486,4.068493 -2.80077,6.420496 -0.14869,3.476556 0.2367,6.948997 0.26846,10.42552 0.0694,2.245339 0.13873,4.490677 0.2081,6.736015 -2.66623,-3.441242 -5.33209,-6.882767 -7.99805,-10.324219 -0.3208,0.613757 -1.1059,1.032702 -0.93164,1.803125 0,1.915886 0,3.831771 0,5.747656 2.81327,1.930662 4.01065,5.357509 4.57662,8.580588 1.05965,5.210592 0.88458,10.747638 3.18314,15.647928 0.79075,1.547502 2.30043,2.675124 4.01161,2.972612 1.74247,0.604816 2.74398,2.625711 2.29964,4.391008 -0.056,2.657401 -0.23651,5.617063 -2.16476,7.655911 -2.01921,2.056686 -5.59119,1.900918 -7.63471,-0.04034 -0.48268,-0.392173 -0.96552,-0.947754 -0.6601,0.0496 6.11815,42.707058 10.97162,85.592878 14.6472,128.578418 1.90601,22.42187 3.37121,44.88199 4.35371,67.36373 0.36888,5.5679 1.5116,11.0429 2.84821,16.40967 2.90054,11.57125 6.94345,22.92544 8.24987,34.84021 0.33397,3.35756 -0.42406,6.6841 -0.78722,10.0057 -0.60979,4.56895 -1.25591,9.21805 -1.6654,13.73246 -0.38605,4.33732 -0.54296,8.82203 -0.10191,13.2163 1.8893,25.07328 4.56433,50.10645 7.43773,75.10575 3.79743,32.78655 8.06585,65.52271 12.22306,98.2794 1.78523,16.22362 0.67232,32.56184 -0.0323,48.81427 -0.49176,10.30125 -0.98851,20.57506 -0.71806,30.90668 0.0353,1.43198 0.0882,2.75754 0.15042,4.20104 0.0935,1.41259 0.1728,3.06135 0.30431,4.56281 0.19596,2.27465 0.46012,4.70879 0.79015,6.90951 1.00563,6.71913 2.7319,13.48979 6.3283,19.32305 2.68686,4.33828 6.64787,7.92766 11.3983,9.86018 2.37552,1.02157 4.89294,1.68521 7.44065,2.10617 0.59657,0.0866 1.50432,0.22442 2.23194,0.29038 1.42685,0.14932 2.60537,0.20536 4.06193,0.24051 2.7945,0.0615 5.58315,-0.17818 8.377,-0.18335 3.82216,-0.23937 7.77718,-0.66034 11.67381,-0.93221 56.80675,-4.46742 113.80557,-5.30554 170.74378,-6.84874 27.0397,-0.72223 54.04566,-1.5792 81.05022,-3.20331 6.22526,-91.02891 13.49788,-181.98328 20.92984,-272.91781 8.27691,-101.71704 16.63062,-203.43453 23.60047,-305.254194 0.97976,-14.189494 1.91149,-28.382241 2.8564,-42.574093 -3.11479,-1.044715 -6.17063,-1.92186 -9.375,-2.695312 -3.81604,-0.914528 -7.90962,-1.701831 -11.89408,-2.287156 -8.06365,-1.208115 -16.39211,-1.806147 -24.61216,-2.110998 -20.44316,-0.725447 -41.06522,0.393112 -61.57627,-0.123082 -13.99315,-0.381252 -28.12905,-1.465951 -41.59722,-5.517849 -0.83183,-0.2407 -1.66957,-0.520167 -2.48237,-0.785134 -2.00467,2.542364 -5.35295,3.322671 -8.40987,3.695292 -4.94376,0.582524 -9.94024,0.15919 -14.87025,-0.359024 -4.01973,-0.46494 -8.01284,-1.165501 -11.94645,-2.115565 -2.24855,1.827786 -5.21009,2.302689 -7.95062,2.952608 -5.47071,1.143117 -11.06061,1.515845 -16.59039,2.250517 -1.23487,0.356251 -2.42735,0.845247 -3.64844,1.246094 -0.53281,-1.723375 -1.27316,-3.378743 -1.72266,-5.126953 -4.49577,-0.620916 -8.81549,-3.26763 -10.96484,-7.326172 -2.92969,0 -5.85938,0 -8.78906,0 -1.07683,3.371781 -3.9055,6.048264 -7.27539,7.080078 -4.63492,1.615112 -9.61757,1.258261 -14.44292,1.377105 -1.35562,0.0099 -2.71123,0.0198 -4.06685,0.02914 0.19064,-1.648565 0.29273,-3.3062 0.49414,-4.953125 -6.22614,1.987951 -12.90675,0.915758 -19.21666,2.421081 -2.68712,0.636228 -5.20146,2.031822 -7.02569,4.124257 -2.4061,2.418005 -4.72872,4.922864 -7.1346,7.337474 -0.52071,0.471292 -1.22174,0.267024 -1.85742,0.308594 -0.33464,-0.624386 -0.85983,-1.244332 -0.58399,-1.992187 0.74504,-3.724411 1.61727,-7.425993 2.32865,-11.156472 0.10001,-0.712668 0.26445,-1.453307 0.0854,-2.165794 -1.91048,-0.236296 -3.78476,0.452204 -5.64843,0.783203 -1.06918,0.217935 -2.13812,0.437008 -3.20703,0.65625 0,-1.285156 0,-2.570312 0,-3.855469 -11.27149,0 -22.54297,0 -33.81446,0 -0.33919,0.170573 -0.67838,0.341146 -1.01758,0.511719 z m 263.91407,31.810547 c 19.72247,0.04356 39.44441,0.399136 59.15429,1.109375 -14.99534,177.88677 -29.08483,355.84822 -42.21986,533.8839 -0.10558,1.82249 -0.35311,3.65997 -0.31564,5.47615 0.43652,1.74728 0.87287,3.49461 1.31089,5.24151 -8.39206,-0.8911 -16.77794,-1.69794 -25.16268,-2.13137 -28.92027,-1.64909 -57.97683,-0.27369 -86.95759,-0.0769 -11.01232,0.0432 -22.05661,-0.0922 -33.00564,-1.36494 -3.8226,-0.61572 -7.13504,-3.00764 -9.5036,-5.99408 -0.35198,-0.32421 -0.59596,-1.08993 -1.13806,-0.59674 -4.40091,1.83592 -9.09725,2.87402 -13.80136,3.57057 -5.26858,0.70097 -10.80776,0.73674 -15.84343,-1.16412 -0.68624,0.51011 -1.43166,1.17174 -2.27928,1.52557 -3.088,1.44274 -6.62001,1.15924 -9.90814,0.76431 -5.00442,-0.74247 -9.86919,-2.23337 -14.62902,-3.91711 -3.93574,-1.41009 -7.77728,-3.09762 -11.43331,-5.12883 -2.22596,0.83566 -3.48732,3.00369 -5.18359,4.53906 -2.62022,2.56836 -6.20004,4.24234 -9.91046,4.14304 -3.92263,-0.0203 -7.68284,-1.29181 -11.51982,-1.94513 -0.86379,-0.044 -1.12311,-0.2824 -0.35086,-0.8526 0.42384,-0.45491 0.84731,-0.91015 1.27138,-1.36484 -2.09266,0.50699 -4.18521,1.08839 -6.31281,1.40264 -1.1698,-0.009 -1.80846,-1.18784 -1.92548,-2.2249 -3.7581,-11.09127 -5.242,-22.81492 -5.85331,-34.46793 -0.61087,-10.80296 -0.56635,-21.60864 -1.30879,-32.38559 -0.28202,-3.83777 -0.65853,-7.92141 -1.21681,-11.74482 -1.24603,-8.86002 -3.56591,-17.61405 -7.3828,-25.72588 -0.32522,-0.649 -0.75656,-1.58775 -1.15986,-2.33295 -1.91489,-3.77902 -4.25679,-7.31684 -6.69171,-10.77643 0.84927,-2.95316 1.56251,-6.2571 4.06641,-8.30078 1.87485,-1.67554 4.59871,-1.82022 6.92886,-1.19964 0.47132,0.0212 -0.0752,-1.09813 -0.008,-1.52949 -9.84698,-70.46348 -15.29378,-141.43196 -21.49446,-212.28305 -3.65697,-42.05625 -7.542,-84.07042 -12.55004,-125.97639 -2.25544,-18.94374 -4.76154,-37.882239 -7.51681,-56.78675 -0.23125,-1.600938 -0.46246,-3.20188 -0.6938,-4.802804 55.50487,0.194121 110.97246,-2.139332 166.43515,-3.983243 42.68867,-1.439048 85.39256,-2.670109 128.10978,-2.598788 z m 14.79297,61.765625 c -3.88394,0.20823 -7.67797,2.13667 -9.95116,5.32575 -3.05898,3.97537 -4.48345,8.9088 -5.50978,13.74456 -0.11629,0.61397 -0.30571,1.536 -0.42387,2.27917 -1.56908,9.27817 -1.56618,18.73132 -1.35738,28.11146 0.3223,12.19162 1.46903,24.43531 1.93569,36.67256 0.29363,8.73549 -0.21384,17.47148 -0.63636,26.19448 -1.6976,31.26009 -5.32874,62.36683 -8.54802,93.49579 -2.17737,20.77333 -4.2543,41.49956 -5.60657,62.33157 -0.38281,6.21152 -0.7307,12.55123 -0.93317,18.75758 -0.37948,10.83122 -0.42333,21.7024 0.10541,32.49024 0.23801,4.71837 0.59866,9.43183 1.13419,14.12614 3.79454,0.0465 7.71522,0.39506 11.38477,-0.78516 0.40915,-0.11157 0.78946,-0.32086 0.8085,-0.79403 0.90691,-2.46937 1.41895,-5.05727 1.78428,-7.59514 1.10689,-7.32412 1.44997,-14.77341 3.17079,-21.99684 1.09707,-4.49149 2.7034,-9.02752 5.83018,-12.53 -2.79634,-3.67928 -3.68671,-8.61899 -2.62426,-13.08969 1.30247,-6.08767 4.96848,-11.41012 9.31762,-15.75016 0.27749,-0.41918 1.06482,-0.66088 0.93635,-1.21215 0.0533,-0.60112 -0.29295,-0.82854 -0.86214,-0.79957 -2.77271,-0.41191 -5.28832,-1.6811 -7.82968,-2.78621 -2.98353,-1.26569 -5.98442,-2.49021 -8.975,-3.73918 4.52516,-1.22846 9.07394,-2.37007 13.61718,-3.52344 0.40288,-0.14132 1.20725,-0.17738 0.60859,-0.70273 -1.39593,-1.84818 -3.64808,-2.71086 -5.52972,-3.95426 -1.70502,-1.01915 -3.4104,-2.03768 -5.11598,-3.0559 3.04113,-1.18674 6.16194,-2.15196 9.19851,-3.34716 2.75985,-0.92612 4.68876,-3.36304 5.7566,-5.98172 1.50524,-3.72875 1.88489,-7.80752 1.96478,-11.79525 0.0425,-3.8954 -0.33506,-7.65847 -0.85115,-11.52494 -1.08466,-7.28509 -2.7114,-14.5213 -5.32037,-21.42149 -0.39099,-1.09032 -0.78153,-2.1808 -1.17219,-3.27123 1.42936,0.0777 2.82491,0.19673 4.14396,0.22483 1.0488,0.0314 2.0995,0.0546 3.14315,0.17165 -0.4294,-17.08693 1.1715,-34.13443 2.77231,-51.12533 1.96463,-20.35127 4.31232,-40.62543 5.60659,-61.01529 0.29509,-4.92824 0.56787,-10.01547 0.71334,-14.93588 0.25671,-8.3993 0.24703,-16.855 -0.22415,-25.1942 -0.48255,-8.55239 -1.45543,-17.097 -3.33684,-25.46172 -0.28125,-1.22567 -0.63461,-2.68759 -0.98148,-3.99431 -0.19321,-0.55619 -0.23726,-1.2812 -0.56028,-1.71573 -2.47518,-0.61568 -5.02988,-0.95486 -7.58324,-0.82707 z m -27.22461,498.82617 c 8.72139,-0.0514 17.43971,0.39918 26.12109,1.21875 0.001,10.31836 0.005,20.63672 0.006,30.95508 -10.81703,0.75532 -21.69874,0.0229 -32.38641,-1.7365 -12.66003,-1.97932 -25.32248,-4.96131 -38.20244,-4.31764 -1.26854,0.0559 -2.73474,0.16959 -3.87599,0.27094 -2.97656,0.30315 -5.93541,0.7504 -8.90625,1.10351 0.42068,-2.68009 1.12304,-5.30528 1.5625,-7.98047 -2.91857,1.29477 -5.57257,3.09571 -8.36078,4.63791 -2.27226,1.26415 -4.71224,2.56535 -7.37226,2.59999 -2.65733,-0.0756 -5.02685,-2.16128 -5.54294,-4.75439 -0.35704,-1.29311 -0.40371,-2.64124 -0.49356,-3.97179 -5.59669,0.01 -11.19865,0.47604 -16.72017,1.3906 -3.40371,0.64448 -6.85283,1.35842 -9.9994,2.85282 -0.81499,0.4069 -1.61261,0.8924 -2.22964,1.57104 0.49043,2.45002 1.06135,4.89366 1.58007,7.34179 -2.47665,-0.65961 -4.97921,-1.22257 -7.45318,-1.88473 -2.20365,-0.60364 -4.10846,-2.22949 -4.88338,-4.40052 -0.25129,-0.64103 -0.39658,-1.32141 -0.46422,-2.00576 -1.39868,-0.19448 -2.73769,-0.33458 -4.19528,-0.48389 -4.05246,-0.39112 -8.16052,-0.60443 -12.16359,-0.67598 -14.3569,-0.23406 -28.58637,1.01175 -42.90788,1.95616 -17.31678,1.17955 -34.75215,2.05659 -52.0604,0.26666 -5.57661,-0.5493 -11.15053,-1.13356 -16.72558,-1.70162 6.42593,-2.94892 12.75284,-6.11278 19.23927,-8.92783 8.89069,-3.80508 18.30167,-6.28431 27.80146,-8.00719 17.84937,-3.15861 36.04544,-3.55605 54.12903,-3.37332 23.52092,0.29142 47.01643,1.80125 70.54386,1.6975 18.64764,-0.10664 37.24769,-2.1238 55.91841,-3.08747 6.00879,-0.32232 12.02399,-0.52348 18.0418,-0.55365 z',
            $this->frameId()
        );
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(-2%%, -15%%) scale(2.15);
        }

        #%2$s path {
            transform: scale(0.75);
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 2;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
