<?php

namespace App\Support\SoftwareUpdate;

use App\Support\SoftwareUpdate\MandatorySeeders\Seeder;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class DatabaseUpdateManager
{
    protected function canMigrate()
    {
        $availableMigrations = count(glob(base_path('database/migrations/*.php')));

        $currentMigrations = DB::table('migrations')->count();

        if ($availableMigrations > $currentMigrations) {
            return true;
        }
    }

    public function hasDatabaseUpdate()
    {
        return $this->canMigrate();
    }

    public function updateDatabase()
    {
        if ($this->canMigrate()) {
            Artisan::call('migrate --force');
        }

        $this->runSeeders();
    }

    private function runSeeders()
    {
        $seeders = glob(__DIR__ . '/MandatorySeeders/*.php');

        foreach ($seeders as $path) {

            $class = __NAMESPACE__ . '\\MandatorySeeders\\' . basename($path, '.php');

            if ($class === Seeder::class) continue;

            $seeder = app($class);

            $seeder->seed();
        }
    }
}
