<?php

namespace App\Support\SoftwareUpdate\MandatorySeeders;

use App\Models\ContentBlock;
use Illuminate\Support\Facades\DB;

class ContentBlockSeeder extends Seeder
{
    protected $rawFile = 'content-blocks';

    protected function beforeRun()
    {

        if (app()->environment('demo')) {
            DB::table('content_blocks')->truncate();
        }
    }

    protected function shouldInsertRow(array $row)
    {
        if (app()->environment('demo')) {
            return true;
        }

        // This will not sync new content blocks after the update, 
        // But it will not reinsert blocks if the user already deleted them.
        // Should implement soft delete to compat this issue.
        return ContentBlock::count() === 0;
    }

    protected function newModel()
    {
        return new ContentBlock();
    }
}
