<?php

namespace App\Support\SoftwareUpdate\MandatorySeeders;

use App\Models\Config;
use App\Models\Page;
use App\Models\QRCode;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class PageSeeder extends Seeder
{
    protected $rawFile = 'pages';

    protected $runOnce = true;

    protected function shouldInsertRow(array $row)
    {
        return true;
    }

    protected function newModel()
    {
        return new Page();
    }

    protected function afterRun()
    {
        collect(QRCode::getTypes())->each(function ($type) {
            $title = ucwords($type) . ' QR Code Generator';
            $slug = Str::slug($title);
            Config::set('qrType.' . $type . '.url', $slug);
        });
    }
}
