<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('subscription_plans', function (Blueprint $table) {
            $table->string('frequency')->default('YEAR')->index();
            $table->decimal('price')->default(0)->index();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('subscription_plans', function (Blueprint $table) {
            $table->dropIndex('subscription_plans_frequency_index');
            $table->dropIndex('subscription_plans_price_index');

            $table->dropColumn('frequency');
            $table->dropColumn('price');
        });
    }
};
