<?php

namespace Database\Seeders;


use Illuminate\Database\Seeder;

use App\Models\Permission;
use App\Models\Role;

class RolePermissionsSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {

        $defaultRole = Role::where('is_default_role_for_new_signup', true)->first();

        $defaultPermissions = Permission::whereIn('slug', [
            'qrcode.list',
            'qrcode.show',
            'qrcode.update',
            'qrcode.store',
            'qrcode.archive',
            'qrcode.showStats',
            'subscription.store',
            'subscription.update',
            'file.show',
            'file.destroy',
        ])->get();

        foreach ($defaultPermissions as $permission) {
            $defaultRole->permissions()->save($permission);
        }
    }
}
