<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

use App\Models\User;
use App\Models\Subscription;
use App\Models\SubscriptionPlan;
use Illuminate\Database\Eloquent\Factories\Sequence;

class SubscriptionSeeder extends Seeder
{


    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Subscription::factory(20)->state(new Sequence(
            fn ($sequence) => [
                'subscription_plan_id' => SubscriptionPlan::all()->random()->id,
                'user_id' => User::all()->random()->id
            ]
        ))->create();
    }
}
