<?php

namespace Database\Seeders;

use App\Models\Subscription;
use App\Models\Transaction;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Eloquent\Factories\Sequence;
use Illuminate\Database\Seeder;

class TransactionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        return Transaction::factory(20)->state(new Sequence(
            function ($sequence) {
                $subscription = Subscription::with('subscription_plan')->get()->random();

                return [
                    'subscription_id' => $subscription->id,
                    'amount' => $subscription->subscription_plan->yearly_price,
                ];
            }
        ))->create();
    }
}
