<style>
    .recent-posts {
        text-align: center;
        line-height: 1.5;
        padding: 1rem;
    }

    .recent-posts-post-title a {
        color: var(--primary-0);
        text-decoration: none;
    }

    .recent-posts .container {
        max-width: var(--container-max-width);
        margin: auto;
    }

    .recent-posts-posts {
        display: grid;
        grid-gap: 1rem;
        grid-template-columns: 1fr;
    }

    @media (min-width: 900px) {
        .recent-posts-posts {
            grid-template-columns: repeat(3, 1fr);
        }
    }

    .recent-posts-post::part(container) {
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        height: 100%;
    }

    .recent-posts qrcg-button {
        width: fit-content;
        margin: 1rem auto;
    }

    .recent-posts-post-excerpt {
        height: 
    }

    .recent-posts-post-readmore {
        color: var(--primary-0);
        display: block;
        margin-top: 1rem;
    }

    .recent-section-footer {
        display: flex;
        align-content: center;
        justify-items: center;
        margin: 1rem 0;
    }

    .recent-posts-section-subtitle {
        color: var(--gray-2);
       
    } 
</style>

<section id="recent-posts" class="recent-posts">
    <div class="container">

        <qrcg-h2 class="recent-posts-section-title">
            {{ t('Recent from our blog') }}
        </qrcg-h2>

        <qrcg-p class="recent-posts-section-subtitle">
            {{ t('Latest news and many more ...') }}
        </qrcg-p>

        <div class="recent-posts-posts">

            @foreach ($recentPosts as $post)
                <qrcg-box class="recent-posts-post">
                    <h3 class="recent-posts-post-title">
                        <a href="{{ $post->url }}">
                            {{ $post->title }}
                        </a>
                    </h3>

                    <div class="recent-posts-post-excerpt">
                        {{ $post->excerpt }}
                    </div>

                    <a href="{{ $post->url }}" class="recent-posts-post-readmore">
                        {{t('continue reading')}}
                    </a>
                </qrcg-box>
            @endforeach

        </div>

        <div class="recent-section-footer">
            <qrcg-button href="/blog">{{t('EXPLORE MORE')}}</qrcg-button>
        </div>
    </div>
</section>