@php
    $id = 'simple-block-' . Str::uuid();
@endphp

<style>
    .{{ $id }} {
        padding: {{ $block->padding }};
        margin: {{ $block->margin }};
        background-color: {{ $block->background_color }};
        line-height: 1.8;
    }

    .{{ $id }}-title {
        margin: 0 0 1rem 0;
        color: {{ $block->title_color}};
        text-align: {{ $block->title_alignment }};
    }

    .{{ $id }}-content {
        color: {{ $block->content_color}};
        text-align: {{ $block->content_alignment }};
    }

    .{{ $id }}-content img {
        max-width: 100%;
    }
</style>

<section class="{{ $id }}">
    <h2 class="{{ $id }}-title">{{ $block->title}}</h2>

    <div class="{{ $id }}-content">
        {!! $block->content_html !!}
    </div>
</section>
