@extends('inner-page.layout')

@section('page-title', PageTitle::makeTitle('Contact us'))

@section('title', 'Contact us')

@section('breadcrumbs')
<a href="{{ url('/') }}">{{t('Home')}}</a>
<a href="{{ route('contact') }}">{{t('Contact')}}</a>
@endsection

@section('content')

<style>
    qrcg-contact-form {
        margin-top: 1rem;
    }

    .contact-layout {
        display: grid;
        
        grid-gap: 1rem;
    }

    @media (min-width: 65rem) {
        .contact-layout {
            grid-template-columns: 2fr 1fr;
        }
    }

    @media (min-width: 35rem) {

        qrcg-contact-form {
            max-width: 25rem;
            margin: auto;
        }

    }
    .block-left-side {

    }
</style>

<div class="contact-layout">

    <div class="block-left-side">
        {{ ContentManager::contentBlocks('Contact: form left side') }}
    </div>

    <qrcg-contact-form></qrcg-contact-form>

</div>

{{ ContentManager::contentBlocks('Contact: form after') }}

@endsection
